/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.internal;

import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SerialExecutor.class);
    final Queue<Runnable> tasks = new LinkedBlockingDeque<Runnable>();
    final Executor executor;
    Runnable active;
    private volatile boolean shutdown;
    private Thread thread;
    private final Object threadLock = new Object();

    public SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void execute(Runnable r) {
        if (this.shutdown) {
            log.debug("Task submitted after the executor was shutdown");
        }
        this.tasks.offer(() -> {
            try {
                if (this.shutdown) {
                    return;
                }
                Object object = this.threadLock;
                synchronized (object) {
                    this.thread = Thread.currentThread();
                }
                r.run();
            }
            catch (Throwable t) {
                this.thread.getUncaughtExceptionHandler().uncaughtException(this.thread, t);
            }
            finally {
                Object object = this.threadLock;
                synchronized (object) {
                    this.thread = null;
                }
                Thread.interrupted();
                this.scheduleNext();
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.active = this.tasks.poll();
        if (this.active != null) {
            try {
                this.executor.execute(this.active);
            }
            catch (RejectedExecutionException e) {
                log.debug("Underlying executor rejected execution", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.shutdown = true;
        this.tasks.clear();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread != null && this.thread != Thread.currentThread()) {
                this.thread.interrupt();
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

