/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1.LabelSelectorAttributes;

public class LabelSelectorAttributesFluent<A extends LabelSelectorAttributesFluent<A>>
extends BaseFluent<A> {
    private String rawSelector;
    private List<LabelSelectorRequirement> requirements = new ArrayList<LabelSelectorRequirement>();
    private Map<String, Object> additionalProperties;

    public LabelSelectorAttributesFluent() {
    }

    public LabelSelectorAttributesFluent(LabelSelectorAttributes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LabelSelectorAttributes instance) {
        LabelSelectorAttributes labelSelectorAttributes = instance = instance != null ? instance : new LabelSelectorAttributes();
        if (instance != null) {
            this.withRawSelector(instance.getRawSelector());
            this.withRequirements(instance.getRequirements());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getRawSelector() {
        return this.rawSelector;
    }

    public A withRawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
        return (A)this;
    }

    public boolean hasRawSelector() {
        return this.rawSelector != null;
    }

    public A addToRequirements(int index, LabelSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<LabelSelectorRequirement>();
        }
        this.requirements.add(index, item);
        return (A)this;
    }

    public A setToRequirements(int index, LabelSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<LabelSelectorRequirement>();
        }
        this.requirements.set(index, item);
        return (A)this;
    }

    public A addToRequirements(LabelSelectorRequirement ... items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.requirements.add(item);
        }
        return (A)this;
    }

    public A addAllToRequirements(Collection<LabelSelectorRequirement> items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.requirements.add(item);
        }
        return (A)this;
    }

    public A removeFromRequirements(LabelSelectorRequirement ... items) {
        if (this.requirements == null) {
            return (A)this;
        }
        for (LabelSelectorRequirement item : items) {
            this.requirements.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRequirements(Collection<LabelSelectorRequirement> items) {
        if (this.requirements == null) {
            return (A)this;
        }
        for (LabelSelectorRequirement item : items) {
            this.requirements.remove(item);
        }
        return (A)this;
    }

    public List<LabelSelectorRequirement> getRequirements() {
        return this.requirements;
    }

    public LabelSelectorRequirement getRequirement(int index) {
        return this.requirements.get(index);
    }

    public LabelSelectorRequirement getFirstRequirement() {
        return this.requirements.get(0);
    }

    public LabelSelectorRequirement getLastRequirement() {
        return this.requirements.get(this.requirements.size() - 1);
    }

    public LabelSelectorRequirement getMatchingRequirement(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.requirements) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequirement(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.requirements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequirements(List<LabelSelectorRequirement> requirements) {
        if (requirements != null) {
            this.requirements = new ArrayList<LabelSelectorRequirement>();
            for (LabelSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        } else {
            this.requirements = null;
        }
        return (A)this;
    }

    public A withRequirements(LabelSelectorRequirement ... requirements) {
        if (this.requirements != null) {
            this.requirements.clear();
            this._visitables.remove("requirements");
        }
        if (requirements != null) {
            for (LabelSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorAttributesFluent that = (LabelSelectorAttributesFluent)o;
        if (!Objects.equals(this.rawSelector, that.rawSelector)) {
            return false;
        }
        if (!Objects.equals(this.requirements, that.requirements)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rawSelector, this.requirements, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rawSelector != null) {
            sb.append("rawSelector:");
            sb.append(this.rawSelector + ",");
        }
        if (this.requirements != null && !this.requirements.isEmpty()) {
            sb.append("requirements:");
            sb.append(String.valueOf(this.requirements) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

