/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.parameters;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.client.cli.ArtifactFetchOptions;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.Preconditions;

public class KubernetesJobManagerParameters
extends AbstractKubernetesParameters {
    private final ClusterSpecification clusterSpecification;

    public KubernetesJobManagerParameters(Configuration flinkConfig, ClusterSpecification clusterSpecification) {
        super(flinkConfig);
        this.clusterSpecification = (ClusterSpecification)Preconditions.checkNotNull((Object)clusterSpecification);
    }

    @Override
    public Map<String, String> getLabels() {
        HashMap labels = new HashMap();
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_LABELS).orElse(Collections.emptyMap()));
        labels.putAll(this.getSelectors());
        return Collections.unmodifiableMap(labels);
    }

    @Override
    public Map<String, String> getSelectors() {
        return KubernetesUtils.getJobManagerSelectors(this.getClusterId());
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return Collections.unmodifiableMap(this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_NODE_SELECTOR).orElse(Collections.emptyMap()));
    }

    @Override
    public Map<String, String> getEnvironments() {
        return ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)this.flinkConfig);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    @Override
    public List<Map<String, String>> getTolerations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_TOLERATIONS).orElse(Collections.emptyList());
    }

    public Optional<File> getPodTemplateFilePath() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_POD_TEMPLATE).map(File::new);
    }

    public List<Map<String, String>> getOwnerReference() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_OWNER_REFERENCE).orElse(Collections.emptyList());
    }

    public Map<String, String> getRestServiceAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.REST_SERVICE_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    public Map<String, String> getRestServiceLabels() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.REST_SERVICE_LABELS).orElse(Collections.emptyMap());
    }

    public Map<String, String> getInternalServiceAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.INTERNAL_SERVICE_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    public Map<String, String> getInternalServiceLabels() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.INTERNAL_SERVICE_LABELS).orElse(Collections.emptyMap());
    }

    public int getJobManagerMemoryMB() {
        return this.clusterSpecification.getMasterMemoryMB();
    }

    public double getJobManagerCPU() {
        return (Double)this.flinkConfig.get(KubernetesConfigOptions.JOB_MANAGER_CPU);
    }

    public double getJobManagerCPULimitFactor() {
        double limitFactor = (Double)this.flinkConfig.get(KubernetesConfigOptions.JOB_MANAGER_CPU_LIMIT_FACTOR);
        Preconditions.checkArgument((limitFactor >= 1.0 ? 1 : 0) != 0, (String)"%s should be greater or equal to 1.", (Object[])new Object[]{KubernetesConfigOptions.JOB_MANAGER_CPU_LIMIT_FACTOR.key()});
        return limitFactor;
    }

    public double getJobManagerMemoryLimitFactor() {
        double limitFactor = (Double)this.flinkConfig.get(KubernetesConfigOptions.JOB_MANAGER_MEMORY_LIMIT_FACTOR);
        Preconditions.checkArgument((limitFactor >= 1.0 ? 1 : 0) != 0, (String)"%s should be greater or equal to 1.", (Object[])new Object[]{KubernetesConfigOptions.JOB_MANAGER_MEMORY_LIMIT_FACTOR.key()});
        return limitFactor;
    }

    public int getRestPort() {
        return (Integer)this.flinkConfig.get(RestOptions.PORT);
    }

    public int getRestBindPort() {
        return Integer.valueOf((String)this.flinkConfig.get(RestOptions.BIND_PORT));
    }

    public int getRPCPort() {
        return (Integer)this.flinkConfig.get(JobManagerOptions.PORT);
    }

    public int getBlobServerPort() {
        int blobServerPort = KubernetesUtils.parsePort(this.flinkConfig, (ConfigOption<String>)BlobServerOptions.PORT);
        Preconditions.checkArgument((blobServerPort > 0 ? 1 : 0) != 0, (String)"%s should not be 0.", (Object[])new Object[]{BlobServerOptions.PORT.key()});
        return blobServerPort;
    }

    public String getServiceAccount() {
        return (String)this.flinkConfig.get(KubernetesConfigOptions.JOB_MANAGER_SERVICE_ACCOUNT);
    }

    public String getEntrypointClass() {
        String entrypointClass = (String)this.flinkConfig.get(KubernetesConfigOptionsInternal.ENTRY_POINT_CLASS);
        Preconditions.checkNotNull((Object)entrypointClass, (String)(KubernetesConfigOptionsInternal.ENTRY_POINT_CLASS + " must be specified!"));
        return entrypointClass;
    }

    public KubernetesConfigOptions.ServiceExposedType getRestServiceExposedType() {
        return (KubernetesConfigOptions.ServiceExposedType)((Object)this.flinkConfig.get(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE));
    }

    public boolean isInternalServiceEnabled() {
        return !HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.flinkConfig);
    }

    public int getReplicas() {
        int replicas = (Integer)this.flinkConfig.get(KubernetesConfigOptions.KUBERNETES_JOBMANAGER_REPLICAS);
        if (replicas < 1) {
            throw new IllegalConfigurationException(String.format("'%s' should not be configured less than one.", KubernetesConfigOptions.KUBERNETES_JOBMANAGER_REPLICAS.key()));
        }
        if (replicas > 1 && !HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.flinkConfig)) {
            throw new IllegalConfigurationException("High availability should be enabled when starting standby JobManagers.");
        }
        return replicas;
    }

    public String getEntrypointArgs() {
        return (String)this.flinkConfig.get(KubernetesConfigOptions.KUBERNETES_JOBMANAGER_ENTRYPOINT_ARGS);
    }

    public String getUserArtifactsBaseDir() {
        return (String)this.flinkConfig.get(ArtifactFetchOptions.BASE_DIR);
    }
}

