/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.entrypoint.KubernetesEntrypointUtils;
import org.apache.flink.kubernetes.entrypoint.KubernetesResourceManagerFactory;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.DynamicParametersConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.SessionClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;

public class KubernetesSessionClusterEntrypoint
extends SessionClusterEntrypoint {
    public KubernetesSessionClusterEntrypoint(Configuration configuration) {
        super(configuration);
    }

    protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return DefaultDispatcherResourceManagerComponentFactory.createSessionComponentFactory((ResourceManagerFactory)KubernetesResourceManagerFactory.getInstance());
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)KubernetesSessionClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration dynamicParameters = (Configuration)ClusterEntrypointUtils.parseParametersOrExit((String[])args, (ParserResultFactory)new DynamicParametersConfigurationParserFactory(), KubernetesSessionClusterEntrypoint.class);
        KubernetesSessionClusterEntrypoint entrypoint = new KubernetesSessionClusterEntrypoint(KubernetesEntrypointUtils.loadConfiguration(dynamicParameters));
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)entrypoint);
    }
}

