/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat;
import org.apache.flink.api.java.hadoop.mapreduce.wrapper.HadoopInputSplit;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopInputFormatTest {
    HadoopInputFormatTest() {
    }

    @Test
    void testConfigure() throws Exception {
        ConfigurableDummyInputFormat inputFormat = (ConfigurableDummyInputFormat)((Object)Mockito.mock(ConfigurableDummyInputFormat.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.configure(new Configuration());
        ((ConfigurableDummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(org.apache.hadoop.conf.Configuration.class));
    }

    @Test
    void testCreateInputSplits() throws Exception {
        DummyInputFormat inputFormat = (DummyInputFormat)((Object)Mockito.mock(DummyInputFormat.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.createInputSplits(2);
        ((DummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).getSplits((JobContext)Mockito.any(JobContext.class));
    }

    @Test
    void testOpen() throws Exception {
        DummyInputFormat inputFormat = (DummyInputFormat)((Object)Mockito.mock(DummyInputFormat.class));
        Mockito.when(inputFormat.createRecordReader((InputSplit)ArgumentMatchers.nullable(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn((Object)new DummyRecordReader());
        HadoopInputSplit inputSplit = (HadoopInputSplit)Mockito.mock(HadoopInputSplit.class);
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.open(inputSplit);
        ((DummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).createRecordReader((InputSplit)ArgumentMatchers.nullable(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class));
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isFalse();
    }

    @Test
    void testClose() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.close();
        ((DummyRecordReader)((Object)Mockito.verify((Object)((Object)recordReader), (VerificationMode)Mockito.times((int)1)))).close();
    }

    @Test
    void testCloseWithoutOpen() throws Exception {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)new DummyInputFormat(), String.class, Long.class, Job.getInstance());
        hadoopInputFormat.close();
    }

    @Test
    void testFetchNextInitialState() throws Exception {
        DummyRecordReader recordReader = new DummyRecordReader();
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.fetchNext();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isTrue();
        Assertions.assertThat((boolean)hadoopInputFormat.hasNext).isFalse();
    }

    @Test
    void testFetchNextRecordReaderHasNewValue() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        Mockito.when((Object)recordReader.nextKeyValue()).thenReturn((Object)true);
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.fetchNext();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isTrue();
        Assertions.assertThat((boolean)hadoopInputFormat.hasNext).isTrue();
    }

    @Test
    void testFetchNextRecordReaderThrowsException() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        Mockito.when((Object)recordReader.nextKeyValue()).thenThrow(new Throwable[]{new InterruptedException()});
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hadoopInputFormat.fetchNext()).isInstanceOf(IOException.class)).hasCauseInstanceOf(InterruptedException.class);
        Assertions.assertThat((boolean)hadoopInputFormat.hasNext).isFalse();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isTrue();
    }

    @Test
    void checkTypeInformation() throws Exception {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, Job.getInstance());
        TypeInformation tupleType = hadoopInputFormat.getProducedType();
        TupleTypeInfo expectedType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.VOID_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Assertions.assertThat((boolean)tupleType.isTupleType()).isTrue();
        Assertions.assertThat((Object)tupleType).isEqualTo((Object)expectedType);
    }

    private HadoopInputFormat<String, Long> setupHadoopInputFormat(InputFormat<String, Long> inputFormat, Job job, RecordReader<String, Long> recordReader) {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(inputFormat, String.class, Long.class, job);
        hadoopInputFormat.recordReader = recordReader;
        return hadoopInputFormat;
    }

    private class ConfigurableDummyInputFormat
    extends DummyInputFormat
    implements Configurable {
        private ConfigurableDummyInputFormat() {
        }

        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    private class DummyInputFormat
    extends InputFormat<String, Long> {
        private DummyInputFormat() {
        }

        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            return null;
        }

        public RecordReader<String, Long> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return new DummyRecordReader();
        }
    }

    private class DummyRecordReader
    extends RecordReader<String, Long> {
        private DummyRecordReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return false;
        }

        public String getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public Long getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
        }
    }

    private class DummyVoidKeyInputFormat<T>
    extends FileInputFormat<Void, T> {
        public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return null;
        }
    }
}

