/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapred.HadoopInputFormat;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopInputSplit;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopInputFormatTest {
    HadoopInputFormatTest() {
    }

    @Test
    void testConfigureWithConfigurableInstance() {
        ConfigurableDummyInputFormat inputFormat = (ConfigurableDummyInputFormat)Mockito.mock(ConfigurableDummyInputFormat.class);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        ((ConfigurableDummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)1))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(JobConf.class));
        hadoopInputFormat.configure(new Configuration());
        ((ConfigurableDummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)2))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(JobConf.class));
    }

    @Test
    void testConfigureWithJobConfigurableInstance() {
        JobConfigurableDummyInputFormat inputFormat = (JobConfigurableDummyInputFormat)Mockito.mock(JobConfigurableDummyInputFormat.class);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        ((JobConfigurableDummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)1))).configure((JobConf)Mockito.any(JobConf.class));
        hadoopInputFormat.configure(new Configuration());
        ((JobConfigurableDummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)2))).configure((JobConf)Mockito.any(JobConf.class));
    }

    @Test
    void testOpenClose() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)Mockito.mock(DummyRecordReader.class);
        DummyInputFormat inputFormat = (DummyInputFormat)Mockito.mock(DummyInputFormat.class);
        Mockito.when(inputFormat.getRecordReader((InputSplit)Mockito.any(InputSplit.class), (JobConf)Mockito.any(JobConf.class), (Reporter)Mockito.any(Reporter.class))).thenReturn((Object)recordReader);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        hadoopInputFormat.open(this.getHadoopInputSplit());
        ((DummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)1))).getRecordReader((InputSplit)Mockito.any(InputSplit.class), (JobConf)Mockito.any(JobConf.class), (Reporter)Mockito.any(Reporter.class));
        ((DummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).createKey();
        ((DummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).createValue();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isFalse();
        hadoopInputFormat.close();
        ((DummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void testOpenWithConfigurableReader() throws Exception {
        ConfigurableDummyRecordReader recordReader = (ConfigurableDummyRecordReader)Mockito.mock(ConfigurableDummyRecordReader.class);
        DummyInputFormat inputFormat = (DummyInputFormat)Mockito.mock(DummyInputFormat.class);
        Mockito.when(inputFormat.getRecordReader((InputSplit)Mockito.any(InputSplit.class), (JobConf)Mockito.any(JobConf.class), (Reporter)Mockito.any(Reporter.class))).thenReturn((Object)recordReader);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        hadoopInputFormat.open(this.getHadoopInputSplit());
        ((DummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)1))).getRecordReader((InputSplit)Mockito.any(InputSplit.class), (JobConf)Mockito.any(JobConf.class), (Reporter)Mockito.any(Reporter.class));
        ((ConfigurableDummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(JobConf.class));
        ((ConfigurableDummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).createKey();
        ((ConfigurableDummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).createValue();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isFalse();
    }

    @Test
    void testCreateInputSplits() throws Exception {
        FileSplit[] result = new FileSplit[]{this.getFileSplit()};
        DummyInputFormat inputFormat = (DummyInputFormat)Mockito.mock(DummyInputFormat.class);
        Mockito.when((Object)inputFormat.getSplits((JobConf)Mockito.any(JobConf.class), Mockito.anyInt())).thenReturn((Object)result);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        hadoopInputFormat.createInputSplits(2);
        ((DummyInputFormat)Mockito.verify((Object)inputFormat, (VerificationMode)Mockito.times((int)1))).getSplits((JobConf)Mockito.any(JobConf.class), Mockito.anyInt());
    }

    @Test
    void testReachedEndWithElementsRemaining() throws IOException {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)new DummyInputFormat(), String.class, Long.class, new JobConf());
        hadoopInputFormat.fetched = true;
        hadoopInputFormat.hasNext = true;
        Assertions.assertThat((boolean)hadoopInputFormat.reachedEnd()).isFalse();
    }

    @Test
    void testReachedEndWithNoElementsRemaining() throws IOException {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)new DummyInputFormat(), String.class, Long.class, new JobConf());
        hadoopInputFormat.fetched = true;
        hadoopInputFormat.hasNext = false;
        Assertions.assertThat((boolean)hadoopInputFormat.reachedEnd()).isTrue();
    }

    @Test
    void testFetchNext() throws IOException {
        DummyRecordReader recordReader = (DummyRecordReader)Mockito.mock(DummyRecordReader.class);
        Mockito.when((Object)recordReader.next((String)ArgumentMatchers.nullable(String.class), (Long)ArgumentMatchers.nullable(Long.class))).thenReturn((Object)true);
        DummyInputFormat inputFormat = (DummyInputFormat)Mockito.mock(DummyInputFormat.class);
        Mockito.when(inputFormat.getRecordReader((InputSplit)Mockito.any(InputSplit.class), (JobConf)Mockito.any(JobConf.class), (Reporter)Mockito.any(Reporter.class))).thenReturn((Object)recordReader);
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)inputFormat, String.class, Long.class, new JobConf());
        hadoopInputFormat.open(this.getHadoopInputSplit());
        hadoopInputFormat.fetchNext();
        ((DummyRecordReader)Mockito.verify((Object)recordReader, (VerificationMode)Mockito.times((int)1))).next((String)ArgumentMatchers.nullable(String.class), Mockito.anyLong());
        Assertions.assertThat((boolean)hadoopInputFormat.hasNext).isTrue();
        Assertions.assertThat((boolean)hadoopInputFormat.fetched).isTrue();
    }

    @Test
    void checkTypeInformation() throws Exception {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, new JobConf());
        TypeInformation tupleType = hadoopInputFormat.getProducedType();
        TupleTypeInfo expectedType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.VOID_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Assertions.assertThat((boolean)tupleType.isTupleType()).isTrue();
        Assertions.assertThat((Object)tupleType).isEqualTo((Object)expectedType);
    }

    @Test
    public void testCloseWithoutOpen() throws Exception {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, new JobConf());
        hadoopInputFormat.close();
    }

    private HadoopInputSplit getHadoopInputSplit() {
        return new HadoopInputSplit(1, (InputSplit)this.getFileSplit(), new JobConf());
    }

    private FileSplit getFileSplit() {
        return new FileSplit(new Path("path"), 1L, 2L, new String[0]);
    }

    private class JobConfigurableDummyInputFormat
    extends DummyInputFormat
    implements JobConfigurable {
        private JobConfigurableDummyInputFormat() {
        }

        public void configure(JobConf jobConf) {
        }
    }

    private class ConfigurableDummyInputFormat
    extends DummyInputFormat
    implements Configurable {
        private ConfigurableDummyInputFormat() {
        }

        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    private class DummyInputFormat
    implements InputFormat<String, Long> {
        private DummyInputFormat() {
        }

        public InputSplit[] getSplits(JobConf jobConf, int i) throws IOException {
            return new InputSplit[0];
        }

        public RecordReader<String, Long> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }
    }

    private class ConfigurableDummyRecordReader
    implements RecordReader<String, Long>,
    Configurable {
        private ConfigurableDummyRecordReader() {
        }

        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }

        public boolean next(String s, Long aLong) throws IOException {
            return false;
        }

        public String createKey() {
            return null;
        }

        public Long createValue() {
            return null;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    private class DummyRecordReader
    implements RecordReader<String, Long> {
        private DummyRecordReader() {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }

        public boolean next(String s, Long aLong) throws IOException {
            return false;
        }

        public String createKey() {
            return null;
        }

        public Long createValue() {
            return null;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }
    }

    private class DummyVoidKeyInputFormat<T>
    extends FileInputFormat<Void, T> {
        DummyVoidKeyInputFormat() {
        }

        public RecordReader<Void, T> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }
    }
}

