/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.hadoop.io.Writable;
import org.assertj.core.api.Condition;

class WritableSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<WritableName, WritableName> {
    WritableSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("writeable-serializer", flinkVersion, WritableSerializerSetup.class, WritableSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class WritableSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<WritableName> {
        public TypeSerializer<WritableName> createUpgradedSerializer() {
            return new WritableSerializer(WritableName.class);
        }

        public Condition<WritableName> testDataCondition() {
            WritableName writable = new WritableName();
            writable.setName("flink");
            return new Condition(writable::equals, "writable is " + writable, new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<WritableName>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class WritableSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<WritableName> {
        public TypeSerializer<WritableName> createPriorSerializer() {
            return new WritableSerializer(WritableName.class);
        }

        public WritableName createTestData() {
            WritableName writable = new WritableName();
            writable.setName("flink");
            return writable;
        }
    }

    public static final class WritableName
    implements Writable {
        public static final long serialVersionUID = 1L;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        public void readFields(DataInput in) throws IOException {
            this.name = in.readUTF();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WritableName)) {
                return false;
            }
            WritableName other = (WritableName)obj;
            return Objects.equals(this.name, other.name);
        }
    }
}

