/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.watermark.WatermarkHandlingResult;
import org.apache.flink.api.common.watermark.WatermarkHandlingStrategy;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.DefaultTwoOutputNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultTwoOutputPartitionedContext;
import org.apache.flink.datastream.impl.context.UnsupportedProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoOutputStreamProcessFunction;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateUdfStreamOperator;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermark.AbstractInternalWatermarkDeclaration;
import org.apache.flink.streaming.runtime.watermark.extension.eventtime.EventTimeWatermarkHandler;
import org.apache.flink.util.OutputTag;

public class TwoOutputProcessOperator<IN, OUT_MAIN, OUT_SIDE>
extends AbstractAsyncStateUdfStreamOperator<OUT_MAIN, TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE>>
implements OneInputStreamOperator<IN, OUT_MAIN>,
BoundedOneInput {
    protected transient TimestampCollector<OUT_MAIN> mainCollector;
    protected transient TimestampCollector<OUT_SIDE> sideCollector;
    protected transient DefaultRuntimeContext context;
    protected transient DefaultTwoOutputPartitionedContext<OUT_MAIN, OUT_SIDE> partitionedContext;
    protected transient TwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE> nonPartitionedContext;
    protected OutputTag<OUT_SIDE> outputTag;
    protected transient Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap;
    protected transient EventTimeWatermarkHandler eventTimeWatermarkHandler;

    public TwoOutputProcessOperator(TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE> userFunction, OutputTag<OUT_SIDE> outputTag) {
        super(userFunction);
        this.outputTag = outputTag;
    }

    public void open() throws Exception {
        this.mainCollector = this.getMainCollector();
        this.sideCollector = this.getSideCollector();
        StreamingRuntimeContext operatorContext = this.getRuntimeContext();
        OperatorStateBackend operatorStateStore = this.getOperatorStateBackend();
        TaskInfo taskInfo = operatorContext.getTaskInfo();
        this.context = new DefaultRuntimeContext(operatorContext.getJobInfo().getJobName(), operatorContext.getJobType(), taskInfo.getNumberOfParallelSubtasks(), taskInfo.getMaxNumberOfParallelSubtasks(), taskInfo.getTaskName(), taskInfo.getIndexOfThisSubtask(), taskInfo.getAttemptNumber(), (MetricGroup)operatorContext.getMetricGroup());
        this.watermarkDeclarationMap = this.config.getWatermarkDeclarations(this.getUserCodeClassloader()).stream().collect(Collectors.toMap(AbstractInternalWatermarkDeclaration::getIdentifier, Function.identity()));
        this.partitionedContext = new DefaultTwoOutputPartitionedContext(this.context, this::currentKey, this.getProcessorWithKey(), this.getProcessingTimeManager(), operatorContext, (OperatorStateStore)operatorStateStore);
        this.nonPartitionedContext = this.getNonPartitionedContext();
        this.partitionedContext.setNonPartitionedContext(this.nonPartitionedContext);
        this.eventTimeWatermarkHandler = new EventTimeWatermarkHandler(1, this.output, this.timeServiceManager);
        if (this.userFunction instanceof EventTimeWrappedTwoOutputStreamProcessFunction) {
            ((EventTimeWrappedTwoOutputStreamProcessFunction)this.userFunction).initEventTimeExtension(this.getTimerService(), this.getEventTimeSupplier(), this.eventTimeWatermarkHandler);
        }
        ((TwoOutputStreamProcessFunction)this.userFunction).open(this.nonPartitionedContext);
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.mainCollector.setTimestampFromStreamRecord(element);
        this.sideCollector.setTimestampFromStreamRecord(element);
        ((TwoOutputStreamProcessFunction)this.userFunction).processRecord(element.getValue(), this.mainCollector, this.sideCollector, this.partitionedContext);
    }

    public void processWatermarkInternal(WatermarkEvent watermark) throws Exception {
        WatermarkHandlingResult watermarkHandlingResultByUserFunction = ((TwoOutputStreamProcessFunction)this.userFunction).onWatermark(watermark.getWatermark(), this.mainCollector, this.sideCollector, this.nonPartitionedContext);
        if (watermarkHandlingResultByUserFunction == WatermarkHandlingResult.PEEK && this.watermarkDeclarationMap.get(watermark.getWatermark().getIdentifier()).getDefaultHandlingStrategy() == WatermarkHandlingStrategy.FORWARD) {
            if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark.getWatermark())) {
                this.eventTimeWatermarkHandler.processWatermark(watermark.getWatermark(), 0);
            } else {
                this.output.emitWatermark(watermark);
            }
        }
    }

    public void endInput() throws Exception {
        ((TwoOutputStreamProcessFunction)this.userFunction).endInput(this.nonPartitionedContext);
    }

    protected TimestampCollector<OUT_MAIN> getMainCollector() {
        return new OutputCollector(this.output);
    }

    public TimestampCollector<OUT_SIDE> getSideCollector() {
        return new SideOutputCollector(this.output);
    }

    protected Object currentKey() {
        throw new UnsupportedOperationException("The key is only defined for keyed operator");
    }

    protected BiConsumer<Runnable, Object> getProcessorWithKey() {
        if (this.isAsyncKeyOrderedProcessingEnabled()) {
            return (r, k) -> this.asyncProcessWithKey(k, r::run);
        }
        return (r, k) -> {
            Object oldKey = this.currentKey();
            try {
                r.run();
            }
            finally {
                this.setCurrentKey(oldKey);
            }
        };
    }

    protected TwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE> getNonPartitionedContext() {
        return new DefaultTwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE>(this.context, this.partitionedContext, this.mainCollector, this.sideCollector, false, null, this.output, this.watermarkDeclarationMap);
    }

    protected ProcessingTimeManager getProcessingTimeManager() {
        return UnsupportedProcessingTimeManager.INSTANCE;
    }

    public void close() throws Exception {
        super.close();
        ((TwoOutputStreamProcessFunction)this.userFunction).close();
    }

    public boolean isAsyncKeyOrderedProcessingEnabled() {
        return false;
    }

    protected InternalTimerService<VoidNamespace> getTimerService() {
        return null;
    }

    protected Supplier<Long> getEventTimeSupplier() {
        return () -> this.eventTimeWatermarkHandler.getLastEmitWatermark();
    }

    protected class SideOutputCollector
    extends TimestampCollector<OUT_SIDE> {
        private final Output<StreamRecord<OUT_MAIN>> output;

        public SideOutputCollector(Output<StreamRecord<OUT_MAIN>> output) {
            this.output = output;
        }

        public void collect(OUT_SIDE outputRecord) {
            this.output.collect(TwoOutputProcessOperator.this.outputTag, this.reuse.replace(outputRecord));
        }

        public void collectAndOverwriteTimestamp(OUT_SIDE record, long timestamp) {
            this.setTimestamp(timestamp);
            this.output.collect(TwoOutputProcessOperator.this.outputTag, this.reuse.replace(record));
        }
    }
}

