/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testutils.source;

import org.apache.flink.api.common.TaskInfo;

public class TestingTaskInfo
implements TaskInfo {
    private final String taskName;
    private final int maxNumberOfParallelSubtasks;
    private final int indexOfThisSubtask;
    private final int numberOfParallelSubtasks;
    private final int attemptNumber;
    private final String taskNameWithSubtasks;
    private final String allocationIDAsString;

    public TestingTaskInfo(String taskName, int maxNumberOfParallelSubtasks, int indexOfThisSubtask, int numberOfParallelSubtasks, int attemptNumber, String taskNameWithSubtasks, String allocationIDAsString) {
        this.taskName = taskName;
        this.maxNumberOfParallelSubtasks = maxNumberOfParallelSubtasks;
        this.indexOfThisSubtask = indexOfThisSubtask;
        this.numberOfParallelSubtasks = numberOfParallelSubtasks;
        this.attemptNumber = attemptNumber;
        this.taskNameWithSubtasks = taskNameWithSubtasks;
        this.allocationIDAsString = allocationIDAsString;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getMaxNumberOfParallelSubtasks() {
        return this.maxNumberOfParallelSubtasks;
    }

    public int getIndexOfThisSubtask() {
        return this.indexOfThisSubtask;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numberOfParallelSubtasks;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String getTaskNameWithSubtasks() {
        return this.taskNameWithSubtasks;
    }

    public String getAllocationIDAsString() {
        return this.allocationIDAsString;
    }

    public static class Builder {
        private String taskName = "";
        private int maxNumberOfParallelSubtasks = 0;
        private int indexOfThisSubtask = -1;
        private int numberOfParallelSubtasks = 0;
        private int attemptNumber = 0;
        private String taskNameWithSubtasks = "";
        private String allocationIDAsString = "";

        public Builder setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public Builder setMaxNumberOfParallelSubtasks(int maxNumberOfParallelSubtasks) {
            this.maxNumberOfParallelSubtasks = maxNumberOfParallelSubtasks;
            return this;
        }

        public Builder setIndexOfThisSubtask(int indexOfThisSubtask) {
            this.indexOfThisSubtask = indexOfThisSubtask;
            return this;
        }

        public Builder setNumberOfParallelSubtasks(int numberOfParallelSubtasks) {
            this.numberOfParallelSubtasks = numberOfParallelSubtasks;
            return this;
        }

        public Builder setAttemptNumber(int attemptNumber) {
            this.attemptNumber = attemptNumber;
            return this;
        }

        public Builder setTaskNameWithSubtasks(String taskNameWithSubtasks) {
            this.taskNameWithSubtasks = taskNameWithSubtasks;
            return this;
        }

        public Builder setAllocationIDAsString(String allocationIDAsString) {
            this.allocationIDAsString = allocationIDAsString;
            return this;
        }

        public TaskInfo build() {
            return new TestingTaskInfo(this.taskName, this.maxNumberOfParallelSubtasks, this.indexOfThisSubtask, this.numberOfParallelSubtasks, this.attemptNumber, this.taskNameWithSubtasks, this.allocationIDAsString);
        }
    }
}

