/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.util.ArrayResultIterator;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayResultIteratorTest {
    ArrayResultIteratorTest() {
    }

    @Test
    void testEmptyConstruction() {
        ArrayResultIterator iter = new ArrayResultIterator();
        Assertions.assertThat((Object)iter.next()).isNull();
    }

    @Test
    void testGetElements() {
        Object[] elements = new String[]{"1", "2", "3", "4"};
        long initialPos = 1422L;
        long initialSkipCount = 17L;
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set(elements, elements.length, 1422L, 17L);
        for (int i = 0; i < elements.length; ++i) {
            RecordAndPosition recAndPos = iter.next();
            Assertions.assertThat((String)((String)recAndPos.getRecord())).isEqualTo((String)elements[i]);
            Assertions.assertThat((long)recAndPos.getOffset()).isEqualTo(1422L);
            Assertions.assertThat((long)recAndPos.getRecordSkipCount()).isEqualTo(17L + (long)i + 1L);
        }
    }

    @Test
    void testExhausted() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set((Object[])new String[]{"1", "2"}, 2, 0L, 0L);
        iter.next();
        iter.next();
        Assertions.assertThat((Object)iter.next()).isNull();
    }

    @Test
    void testArraySubRange() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set((Object[])new String[]{"1", "2", "3"}, 2, 0L, 0L);
        Assertions.assertThat((Object)iter.next()).isNotNull();
        Assertions.assertThat((Object)iter.next()).isNotNull();
        Assertions.assertThat((Object)iter.next()).isNull();
    }

    @Test
    void testNoRecycler() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.releaseBatch();
    }

    @Test
    void testRecycler() {
        AtomicBoolean recycled = new AtomicBoolean();
        ArrayResultIterator iter = new ArrayResultIterator(() -> recycled.set(true));
        iter.releaseBatch();
        Assertions.assertThat((boolean)recycled.get()).isTrue();
    }
}

