/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveAllDirEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumeratorTest;
import org.apache.flink.connector.file.src.testutils.TestingFileSystem;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class NonSplittingRecursiveAllDirEnumeratorTest {
    protected TestingFileSystem testFs;

    @AfterEach
    void unregisterTestFs() throws Exception {
        if (this.testFs != null) {
            this.testFs.unregister();
        }
    }

    @Test
    void testIncludeSingleFile() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///dir/file1"), new Path("testfs:///dir/nested/file.out"), new Path("testfs:///dir/nested/anotherfile.txt")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        Path baseDir = new Path("testfs:///dir");
        FileEnumerator enumerator = this.createEnumerator(baseDir.getPath() + "/nested/file.out");
        Collection splits = enumerator.enumerateSplits(new Path[]{baseDir}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).containsExactlyInAnyOrder((Object[])new Path[]{testPaths[1]});
    }

    @Test
    void testIncludeFilesFromRegexDirectory() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///dir/file1"), new Path("testfs:///dir/nested/file.out"), new Path("testfs:///dir/nested/anotherFile.txt"), new Path("testfs:///dir/nested/nested/doubleNestedFile.txt")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        Path baseDir = new Path("testfs:///dir");
        FileEnumerator enumerator = this.createEnumerator(baseDir.getPath() + "/nest.[a-z]/.*");
        Collection splits = enumerator.enumerateSplits(new Path[]{baseDir}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).containsExactlyInAnyOrder((Object[])Arrays.copyOfRange(testPaths, 1, testPaths.length));
    }

    @Test
    void testIncludeSingleFileFromMultiDirectory() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///dir/file1"), new Path("testfs:///dir/nested/file.out"), new Path("testfs:///dir/nested/anotherFile.txt"), new Path("testfs:///dir/nested/nested/doubleNestedFile.txt"), new Path("testfs:///dir/anotherNested/file.out"), new Path("testfs:///dir/anotherNested/nested/file.out")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        Path baseDir = new Path("testfs:///dir");
        FileEnumerator enumerator = this.createEnumerator(baseDir.getPath() + "/.*/file.out");
        Collection splits = enumerator.enumerateSplits(new Path[]{baseDir}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).containsExactlyInAnyOrder((Object[])((Path[])Arrays.stream(testPaths).filter(p -> p.getPath().endsWith("file.out")).toArray(Path[]::new)));
    }

    @Test
    void testDefaultHiddenFilesFilter() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///visiblefile"), new Path("testfs:///.hiddenfile1"), new Path("testfs:///_hiddenfile2")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        Path baseDir = new Path("testfs:///");
        FileEnumerator enumerator = this.createEnumerator("/.*");
        Collection splits = enumerator.enumerateSplits(new Path[]{baseDir}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).isEqualTo(Collections.singletonList(testPaths[0]));
    }

    @Test
    void testHiddenDirectories() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///dir/visiblefile"), new Path("testfs:///dir/.hiddendir/file"), new Path("testfs:///_notvisible/afile")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        Path baseDir = new Path("testfs:///");
        FileEnumerator enumerator = this.createEnumerator("/.*");
        Collection splits = enumerator.enumerateSplits(new Path[]{baseDir}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).isEqualTo(Collections.singletonList(testPaths[0]));
    }

    @Test
    void testFilesWithNoBlockInfo() throws Exception {
        Path testPath = new Path("testfs:///dir/file1");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 12345L, new BlockLocation[0]));
        this.testFs.register();
        FileEnumerator enumerator = this.createEnumerator("/.*/file.");
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 0);
        Assertions.assertThat((Collection)splits).hasSize(1);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 12345L, 0L, 12345L), (FileSourceSplit)splits.iterator().next());
    }

    @Test
    void testFileWithIncorrectBlocks() throws Exception {
        Path testPath = new Path("testfs:///testdir/testfile");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 10000L, new TestingFileSystem.TestBlockLocation(0L, 1000L, new String[0]), new TestingFileSystem.TestBlockLocation(2000L, 1000L, new String[0])));
        this.testFs.register();
        FileEnumerator enumerator = this.createEnumerator("/.*");
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///testdir")}, 0);
        Assertions.assertThat((Collection)splits).hasSize(1);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 10000L, 0L, 12345L), (FileSourceSplit)splits.iterator().next());
    }

    @Test
    void testFileWithMultipleBlocks() throws Exception {
        Path testPath = new Path("testfs:///dir/file");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 1000L, new TestingFileSystem.TestBlockLocation(0L, 100L, "host1", "host2"), new TestingFileSystem.TestBlockLocation(100L, 520L, "host2", "host3"), new TestingFileSystem.TestBlockLocation(620L, 380L, "host3", "host4")));
        this.testFs.register();
        FileEnumerator enumerator = this.createEnumerator(testPath.getPath());
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 0);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 1000L, 0L, 1000L, new String[]{"host1", "host2", "host3", "host4"}), (FileSourceSplit)splits.iterator().next());
    }

    protected FileEnumerator createEnumerator(String pattern) {
        return new NonSplittingRecursiveAllDirEnumerator(pattern);
    }
}

