/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.connector.file.sink.BatchExecutionFileSinkITCase;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.sink.compactor.DecoderBasedReader;
import org.apache.flink.connector.file.sink.compactor.FileCompactStrategy;
import org.apache.flink.connector.file.sink.compactor.FileCompactor;
import org.apache.flink.connector.file.sink.compactor.RecordWiseFileCompactor;
import org.apache.flink.connector.file.sink.utils.IntegerFileSinkTestDataUtils;
import org.apache.flink.connector.file.sink.utils.PartSizeAndCheckpointRollingPolicy;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.junit.jupiter.api.extension.RegisterExtension;

class BatchCompactingFileSinkITCase
extends BatchExecutionFileSinkITCase {
    private static final int PARALLELISM = 4;
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).setRpcServiceSharing(RpcServiceSharing.DEDICATED).withHaLeadershipControl().build());

    BatchCompactingFileSinkITCase() {
    }

    @Override
    protected FileSink<Integer> createFileSink(String path) {
        return ((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(path), (Encoder)new IntegerFileSinkTestDataUtils.IntEncoder()).withBucketAssigner((BucketAssigner)new IntegerFileSinkTestDataUtils.ModuloBucketAssigner(4))).withRollingPolicy(new PartSizeAndCheckpointRollingPolicy(1024L, false))).enableCompact(BatchCompactingFileSinkITCase.createFileCompactStrategy(), BatchCompactingFileSinkITCase.createFileCompactor())).build();
    }

    @Override
    protected void configureSink(DataStreamSink<Integer> sink) {
        sink.uid("sink");
    }

    private static FileCompactor createFileCompactor() {
        return new RecordWiseFileCompactor((RecordWiseFileCompactor.Reader.Factory)new DecoderBasedReader.Factory(IntegerFileSinkTestDataUtils.IntDecoder::new));
    }

    private static FileCompactStrategy createFileCompactStrategy() {
        return FileCompactStrategy.Builder.newBuilder().setSizeThreshold(10000L).build();
    }
}

