/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.mocks;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;

public class TestingSplitReader<E, SplitT extends SourceSplit>
implements SplitReader<E, SplitT> {
    private final ArrayDeque<RecordsWithSplitIds<E>> fetches;
    private volatile boolean closed;
    private volatile boolean closeWithException;

    @SafeVarargs
    public TestingSplitReader(RecordsWithSplitIds<E> ... fetches) {
        this.fetches = new ArrayDeque(fetches.length);
        this.fetches.addAll(Arrays.asList(fetches));
        this.closed = false;
        this.closeWithException = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsWithSplitIds<E> fetch() throws IOException {
        if (!this.fetches.isEmpty()) {
            return this.fetches.removeFirst();
        }
        ArrayDeque<RecordsWithSplitIds<E>> arrayDeque = this.fetches;
        synchronized (arrayDeque) {
            try {
                this.fetches.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
    }

    public void handleSplitsChanges(SplitsChange<SplitT> splitsChanges) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        ArrayDeque<RecordsWithSplitIds<E>> arrayDeque = this.fetches;
        synchronized (arrayDeque) {
            this.fetches.notifyAll();
        }
    }

    public void close() throws Exception {
        if (this.closeWithException) {
            throw new Exception("Artificial exception on closing the split reader.");
        }
        this.closed = true;
    }

    public void setCloseWithException() {
        this.closeWithException = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

