/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer.config;

import org.apache.flink.connector.base.sink.writer.config.AsyncSinkWriterConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AsyncSinkWriterConfigurationBuilderTest {
    AsyncSinkWriterConfigurationBuilderTest() {
    }

    @Test
    void testBuilderSetsValueForTimeoutAndFailOnTimeout() {
        AsyncSinkWriterConfiguration configuration = AsyncSinkWriterConfiguration.builder().setMaxBatchSize(1).setMaxBatchSizeInBytes(10L).setMaxInFlightRequests(1).setMaxBufferedRequests(2).setMaxTimeInBufferMS(10L).setMaxRecordSizeInBytes(2L).setRequestTimeoutMS(100L).setFailOnTimeout(true).build();
        Assertions.assertThat((long)configuration.getRequestTimeoutMS()).isEqualTo(100L);
        Assertions.assertThat((boolean)configuration.isFailOnTimeout()).isTrue();
    }

    @Test
    void testBuilderSetsDefaultValuesForTimeoutAndFailOnTimeout() {
        AsyncSinkWriterConfiguration configuration = AsyncSinkWriterConfiguration.builder().setMaxBatchSize(1).setMaxBatchSizeInBytes(10L).setMaxInFlightRequests(1).setMaxBufferedRequests(2).setMaxTimeInBufferMS(10L).setMaxRecordSizeInBytes(2L).build();
        Assertions.assertThat((long)configuration.getRequestTimeoutMS()).isEqualTo(AsyncSinkWriterConfiguration.DEFAULT_REQUEST_TIMEOUT_MS);
        Assertions.assertThat((boolean)configuration.isFailOnTimeout()).isEqualTo(false);
    }
}

