/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.util.List;
import org.apache.flink.connector.base.sink.writer.DequeRequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DequeRequestBufferTest {
    private DequeRequestBuffer<String> bufferWrapper;

    @BeforeEach
    void setUp() {
        this.bufferWrapper = new DequeRequestBuffer();
    }

    @Test
    void shouldAddEntriesInFifoOrder() {
        RequestEntryWrapper entry1 = new RequestEntryWrapper((Object)"Entry1", 10L);
        RequestEntryWrapper entry2 = new RequestEntryWrapper((Object)"Entry2", 20L);
        this.bufferWrapper.add(entry1, false);
        this.bufferWrapper.add(entry2, false);
        Assertions.assertThat((int)this.bufferWrapper.size()).isEqualTo(2);
        Assertions.assertThat((Object)this.bufferWrapper.peek()).isEqualTo((Object)entry1);
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isEqualTo((Object)entry1);
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isEqualTo((Object)entry2);
        Assertions.assertThat((boolean)this.bufferWrapper.isEmpty()).isTrue();
    }

    @Test
    void shouldPrioritizeEntriesAddedAtHead() {
        RequestEntryWrapper entry1 = new RequestEntryWrapper((Object)"Entry1", 10L);
        RequestEntryWrapper entry2 = new RequestEntryWrapper((Object)"Entry2", 20L);
        RequestEntryWrapper priorityEntry = new RequestEntryWrapper((Object)"PriorityEntry", 30L);
        this.bufferWrapper.add(entry1, false);
        this.bufferWrapper.add(entry2, false);
        this.bufferWrapper.add(priorityEntry, true);
        Assertions.assertThat((int)this.bufferWrapper.size()).isEqualTo(3);
        Assertions.assertThat((Object)this.bufferWrapper.peek()).isEqualTo((Object)priorityEntry);
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isEqualTo((Object)priorityEntry);
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isEqualTo((Object)entry1);
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isEqualTo((Object)entry2);
    }

    @Test
    void shouldTrackTotalSizeCorrectly() {
        RequestEntryWrapper entry1 = new RequestEntryWrapper((Object)"Entry1", 10L);
        RequestEntryWrapper entry2 = new RequestEntryWrapper((Object)"Entry2", 20L);
        this.bufferWrapper.add(entry1, false);
        this.bufferWrapper.add(entry2, false);
        Assertions.assertThat((long)this.bufferWrapper.totalSizeInBytes()).isEqualTo(30L);
        this.bufferWrapper.poll();
        Assertions.assertThat((long)this.bufferWrapper.totalSizeInBytes()).isEqualTo(20L);
        this.bufferWrapper.poll();
        Assertions.assertThat((long)this.bufferWrapper.totalSizeInBytes()).isEqualTo(0L);
    }

    @Test
    void shouldReturnBufferedStateSnapshot() {
        RequestEntryWrapper entry1 = new RequestEntryWrapper((Object)"Entry1", 10L);
        RequestEntryWrapper entry2 = new RequestEntryWrapper((Object)"Entry2", 20L);
        this.bufferWrapper.add(entry1, false);
        this.bufferWrapper.add(entry2, false);
        List snapshot = (List)this.bufferWrapper.getBufferedState();
        Assertions.assertThat((List)snapshot).containsExactly((Object[])new RequestEntryWrapper[]{entry1, entry2});
    }

    @Test
    void shouldHandleEmptyBufferCorrectly() {
        Assertions.assertThat((boolean)this.bufferWrapper.isEmpty()).isTrue();
        Assertions.assertThat((Object)this.bufferWrapper.poll()).isNull();
        Assertions.assertThat((Object)this.bufferWrapper.peek()).isNull();
        Assertions.assertThat((long)this.bufferWrapper.totalSizeInBytes()).isEqualTo(0L);
    }
}

