/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.throwable;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.connector.base.sink.throwable.FatalExceptionClassifier;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class FatalExceptionClassifierTest {
    private static Integer nullReference;
    private static final FatalExceptionClassifier ARITHMETIC_EXCEPTION_STRATEGY;
    private static final FatalExceptionClassifier NULL_POINTER_EXCEPTION_STRATEGY;

    FatalExceptionClassifierTest() {
    }

    @Test
    void exceptionsAreWrappedInTheContainingExceptionWhenAMatchIsFound() {
        AtomicReference caughtExceptionReference = new AtomicReference();
        ARITHMETIC_EXCEPTION_STRATEGY.isFatal((Throwable)new ArithmeticException("Base arithmetic exception"), caughtExceptionReference::set);
        this.assertThatCaughtExceptionIsWrappedArithmeticDivByZeroException((Exception)caughtExceptionReference.get());
    }

    @Test
    void noExceptionIsThrownIfTheExceptionDoesNotMatchTheOneExpected() {
        AtomicReference caughtException = new AtomicReference();
        try {
            System.out.print(nullReference.toString());
        }
        catch (Exception e) {
            ARITHMETIC_EXCEPTION_STRATEGY.isFatal((Throwable)e, caughtException::set);
        }
        AssertionsForClassTypes.assertThat((Throwable)((Exception)caughtException.get())).isNull();
    }

    @Test
    void chainedFatalExceptionClassifierAcceptExceptionsOnTheFirstItemOfChain() {
        FatalExceptionClassifier fatalExceptionClassifier = FatalExceptionClassifier.createChain((FatalExceptionClassifier[])new FatalExceptionClassifier[]{ARITHMETIC_EXCEPTION_STRATEGY, NULL_POINTER_EXCEPTION_STRATEGY});
        AtomicReference caughtExceptionReference = new AtomicReference();
        fatalExceptionClassifier.isFatal((Throwable)new ArithmeticException("Base arithmetic exception"), caughtExceptionReference::set);
        this.assertThatCaughtExceptionIsWrappedArithmeticDivByZeroException((Exception)caughtExceptionReference.get());
    }

    @Test
    void chainedFatalExceptionClassifierAcceptExceptionsOnTheLastItemOfChain() {
        FatalExceptionClassifier fatalExceptionClassifier = FatalExceptionClassifier.createChain((FatalExceptionClassifier[])new FatalExceptionClassifier[]{ARITHMETIC_EXCEPTION_STRATEGY, NULL_POINTER_EXCEPTION_STRATEGY});
        AtomicReference caughtException = new AtomicReference();
        fatalExceptionClassifier.isFatal((Throwable)new NullPointerException("Base NullPointerException"), caughtException::set);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)AssertionsForClassTypes.assertThat((Throwable)((Exception)caughtException.get())).isInstanceOf(RuntimeException.class)).hasMessage("Buffer manipulation calculations resulted in a reference exception").cause().isInstanceOf(NullPointerException.class)).hasMessage("Base NullPointerException");
    }

    @Test
    void circularChainedFatalExceptionClassifierThrowsException() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> FatalExceptionClassifier.createChain((FatalExceptionClassifier[])new FatalExceptionClassifier[]{ARITHMETIC_EXCEPTION_STRATEGY, NULL_POINTER_EXCEPTION_STRATEGY, ARITHMETIC_EXCEPTION_STRATEGY})).withMessageContaining("Wrong classifier chain; Circular chain of classifiers detected");
    }

    @Test
    void emptyChainedFatalExceptionClassifierThrowsException() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> FatalExceptionClassifier.createChain((FatalExceptionClassifier[])new FatalExceptionClassifier[0])).withMessageContaining("Cannot create empty classifier chain.");
    }

    private void assertThatCaughtExceptionIsWrappedArithmeticDivByZeroException(Exception caughtException) {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)AssertionsForClassTypes.assertThat((Throwable)caughtException).isInstanceOf(RuntimeException.class)).hasMessage("Buffer manipulation calculations resulted in a calculation exception").cause().isInstanceOf(ArithmeticException.class)).hasMessage("Base arithmetic exception");
    }

    static {
        ARITHMETIC_EXCEPTION_STRATEGY = new FatalExceptionClassifier(err -> ExceptionUtils.findThrowable((Throwable)err, ArithmeticException.class).isPresent(), err -> new RuntimeException("Buffer manipulation calculations resulted in a calculation exception", (Throwable)err));
        NULL_POINTER_EXCEPTION_STRATEGY = new FatalExceptionClassifier(err -> ExceptionUtils.findThrowable((Throwable)err, NullPointerException.class).isPresent(), err -> new RuntimeException("Buffer manipulation calculations resulted in a reference exception", (Throwable)err));
    }
}

