/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.aftermatch;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

abstract class SkipToElementStrategy
extends AfterMatchSkipStrategy {
    private static final long serialVersionUID = 7127107527654629026L;
    private final String patternName;
    private final boolean shouldThrowException;

    SkipToElementStrategy(String patternName, boolean shouldThrowException) {
        this.patternName = (String)Preconditions.checkNotNull((Object)patternName);
        this.shouldThrowException = shouldThrowException;
    }

    @Override
    public boolean isSkipStrategy() {
        return true;
    }

    @Override
    protected boolean shouldPrune(EventId startEventID, EventId pruningId) {
        return startEventID != null && startEventID.compareTo(pruningId) < 0;
    }

    @Override
    protected EventId getPruningId(Collection<Map<String, List<EventId>>> match) {
        EventId pruningId = null;
        for (Map<String, List<EventId>> resultMap : match) {
            List<EventId> pruningPattern = resultMap.get(this.patternName);
            if (pruningPattern == null || pruningPattern.isEmpty()) {
                if (this.shouldThrowException) {
                    throw new FlinkRuntimeException(String.format("Could not skip to %s. No such element in the found match %s", this.patternName, resultMap));
                }
            } else {
                pruningId = SkipToElementStrategy.max(pruningId, pruningPattern.get(this.getIndex(pruningPattern.size())));
            }
            if (!this.shouldThrowException) continue;
            EventId startEvent = (EventId)resultMap.values().stream().flatMap(Collection::stream).min(EventId::compareTo).orElseThrow(() -> new IllegalStateException("Cannot prune based on empty match"));
            if (pruningId == null || !pruningId.equals(startEvent)) continue;
            throw new FlinkRuntimeException("Could not skip to first element of a match.");
        }
        return pruningId;
    }

    @Override
    public Optional<String> getPatternName() {
        return Optional.of(this.patternName);
    }

    abstract int getIndex(int var1);

    public abstract SkipToElementStrategy throwExceptionOnMiss();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkipToElementStrategy that = (SkipToElementStrategy)o;
        return this.shouldThrowException == that.shouldThrowException && Objects.equals(this.patternName, that.patternName);
    }

    public int hashCode() {
        return Objects.hash(this.patternName, this.shouldThrowException);
    }
}

