/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvroSerializerConcurrencyTest {
    AvroSerializerConcurrencyTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentUseOfSerializer() throws Exception {
        final AvroSerializer serializer = new AvroSerializer(String.class);
        BlockerSync sync = new BlockerSync();
        DataOutputSerializer regularOut = new DataOutputSerializer(32);
        LockingView lockingOut = new LockingView(sync);
        CheckedThread thread = new CheckedThread("serializer", (DataOutputView)lockingOut){
            final /* synthetic */ DataOutputView val$lockingOut;
            {
                this.val$lockingOut = dataOutputView;
                super(name);
            }

            public void go() throws Exception {
                serializer.serialize((Object)"a value", this.val$lockingOut);
            }
        };
        thread.start();
        sync.awaitBlocker();
        try {
            serializer.serialize((Object)"value", (DataOutputView)regularOut);
            Assertions.fail((String)"should have failed with an exception");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            sync.releaseBlocker();
        }
        thread.sync();
    }

    private static class LockingView
    extends DataOutputSerializer {
        private final BlockerSync blocker;

        LockingView(BlockerSync blocker) {
            super(32);
            this.blocker = blocker;
        }

        public void writeInt(int v) throws IOException {
            this.blocker.blockNonInterruptible();
        }
    }
}

