/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class AvroSchemaConverterTest {
    AvroSchemaConverterTest() {
    }

    @Test
    void testAvroClassConversion() {
        this.validateUserSchema(AvroSchemaConverter.convertToTypeInfo(User.class));
    }

    @Test
    void testAvroSchemaConversion() {
        String schema = User.getClassSchema().toString(true);
        this.validateUserSchema(AvroSchemaConverter.convertToTypeInfo((String)schema));
    }

    @Test
    void testConvertAvroSchemaToDataType() {
        String schema = User.getClassSchema().toString(true);
        this.validateUserSchema(AvroSchemaConverter.convertToDataType((String)schema));
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testAddingOptionalField(AvroFormatOptions.AvroEncoding encoding) throws IOException {
        BinaryDecoder decoder;
        Schema oldSchema = (Schema)SchemaBuilder.record((String)"record").fields().requiredLong("category_id").optionalString("name").endRecord();
        Schema newSchema = AvroSchemaConverter.convertToSchema((LogicalType)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"category_id", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"name", (DataType)((DataType)DataTypes.STRING().nullable())), Column.physical((String)"description", (DataType)((DataType)DataTypes.STRING().nullable()))}).toSourceRowDataType().getLogicalType());
        byte[] serializedRecord = AvroTestUtils.writeRecord((GenericRecord)new GenericRecordBuilder(oldSchema).set("category_id", (Object)1L).set("name", (Object)"test").build(), oldSchema, encoding);
        GenericDatumReader datumReader = new GenericDatumReader(oldSchema, newSchema);
        if (encoding == AvroFormatOptions.AvroEncoding.JSON) {
            ByteArrayInputStream input = new ByteArrayInputStream(serializedRecord);
            decoder = DecoderFactory.get().jsonDecoder(oldSchema, (InputStream)input);
        } else {
            decoder = DecoderFactory.get().binaryDecoder(serializedRecord, 0, serializedRecord.length, null);
        }
        GenericRecord newRecord = (GenericRecord)datumReader.read(null, (Decoder)decoder);
        Assertions.assertThat((Object)newRecord).isEqualTo((Object)new GenericRecordBuilder(newSchema).set("category_id", (Object)1L).set("name", (Object)"test").set("description", null).build());
    }

    @Test
    void testInvalidRawTypeAvroSchemaConversion() {
        RowType rowType = (RowType)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.RAW(Void.class, (TypeSerializer)VoidSerializer.INSTANCE))}).toSourceRowDataType().getLogicalType();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AvroSchemaConverter.convertToSchema((LogicalType)rowType)).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Unsupported to derive Schema for type: RAW");
    }

    @Test
    void testInvalidTimestampTypeAvroSchemaConversion() {
        RowType rowType = (RowType)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.TIMESTAMP((int)9))}).toSourceRowDataType().getLogicalType();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AvroSchemaConverter.convertToSchema((LogicalType)rowType)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 9, it only supports precision less than 3.");
    }

    @Test
    void testInvalidTimeTypeAvroSchemaConversion() {
        RowType rowType = (RowType)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.TIME((int)6))}).toSourceRowDataType().getLogicalType();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AvroSchemaConverter.convertToSchema((LogicalType)rowType)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIME type with precision: 6, it only supports precision less than 3.");
    }

    @Test
    void testRowTypeAvroSchemaConversion() {
        RowType rowType = (RowType)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"row1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING())})), Column.physical((String)"row2", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.STRING())})), Column.physical((String)"row3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"row3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c", (DataType)DataTypes.STRING())}))}))}).toSourceRowDataType().getLogicalType();
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)rowType);
        Assertions.assertThat((String)schema.toString(true)).isEqualTo("{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"namespace\" : \"org.apache.flink.avro.generated\",\n  \"fields\" : [ {\n    \"name\" : \"row1\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"record\",\n      \"name\" : \"record_row1\",\n      \"fields\" : [ {\n        \"name\" : \"a\",\n        \"type\" : [ \"null\", \"string\" ],\n        \"default\" : null\n      } ]\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"row2\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"record\",\n      \"name\" : \"record_row2\",\n      \"fields\" : [ {\n        \"name\" : \"b\",\n        \"type\" : [ \"null\", \"string\" ],\n        \"default\" : null\n      } ]\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"row3\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"record\",\n      \"name\" : \"record_row3\",\n      \"fields\" : [ {\n        \"name\" : \"row3\",\n        \"type\" : [ \"null\", {\n          \"type\" : \"record\",\n          \"name\" : \"record_row3_row3\",\n          \"fields\" : [ {\n            \"name\" : \"c\",\n            \"type\" : [ \"null\", \"string\" ],\n            \"default\" : null\n          } ]\n        } ],\n        \"default\" : null\n      } ]\n    } ],\n    \"default\" : null\n  } ]\n}");
    }

    @Test
    void testDataTypeToSchemaToDataTypeNullable() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_null", (DataType)DataTypes.NULL()), DataTypes.FIELD((String)"f_boolean", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"f_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_bigint", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"f_double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f_string", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f_varbinary", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_time", (DataType)DataTypes.TIME((int)3)), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)10, (int)0)), DataTypes.FIELD((String)"f_row", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.TIMESTAMP((int)3))})), DataTypes.FIELD((String)"f_map", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)DataTypes.INT())), DataTypes.FIELD((String)"f_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))});
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        DataType converted = AvroSchemaConverter.convertToDataType((String)schema.toString());
        Assertions.assertThat((Object)converted).isEqualTo((Object)dataType);
    }

    @Test
    void testDataTypeToSchemaToDataTypeNonNullable() {
        DataType dataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_boolean", (DataType)((DataType)DataTypes.BOOLEAN().notNull())), DataTypes.FIELD((String)"f_int", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"f_bigint", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"f_float", (DataType)((DataType)DataTypes.FLOAT().notNull())), DataTypes.FIELD((String)"f_double", (DataType)((DataType)DataTypes.DOUBLE().notNull())), DataTypes.FIELD((String)"f_string", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"f_varbinary", (DataType)((DataType)DataTypes.BYTES().notNull())), DataTypes.FIELD((String)"f_timestamp", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), DataTypes.FIELD((String)"f_date", (DataType)((DataType)DataTypes.DATE().notNull())), DataTypes.FIELD((String)"f_time", (DataType)((DataType)DataTypes.TIME((int)3).notNull())), DataTypes.FIELD((String)"f_decimal", (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)0).notNull())), DataTypes.FIELD((String)"f_row", (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull()))}).notNull())), DataTypes.FIELD((String)"f_map", (DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull())), DataTypes.FIELD((String)"f_array", (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull()))}).notNull();
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        DataType converted = AvroSchemaConverter.convertToDataType((String)schema.toString());
        Assertions.assertThat((Object)converted).isEqualTo((Object)dataType);
    }

    @Test
    void testSchemaToDataTypeToSchemaNullable() {
        String schemaStr = "{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"namespace\" : \"org.apache.flink.avro.generated\",\n  \"fields\" : [ {\n    \"name\" : \"f_null\",\n    \"type\" : \"null\",\n    \"default\" : null\n  }, {\n    \"name\" : \"f_boolean\",\n    \"type\" : [ \"null\", \"boolean\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_int\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_bigint\",\n    \"type\" : [ \"null\", \"long\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_float\",\n    \"type\" : [ \"null\", \"float\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_double\",\n    \"type\" : [ \"null\", \"double\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_string\",\n    \"type\" : [ \"null\", \"string\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_varbinary\",\n    \"type\" : [ \"null\", \"bytes\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_timestamp\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"long\",\n      \"logicalType\" : \"timestamp-millis\"\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_date\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"int\",\n      \"logicalType\" : \"date\"\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_time\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"int\",\n      \"logicalType\" : \"time-millis\"\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_decimal\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"bytes\",\n      \"logicalType\" : \"decimal\",\n      \"precision\" : 10,\n      \"scale\" : 0\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_row\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"record\",\n      \"name\" : \"record_f_row\",\n      \"fields\" : [ {\n        \"name\" : \"f0\",\n        \"type\" : [ \"null\", \"int\" ],\n        \"default\" : null\n      }, {\n        \"name\" : \"f1\",\n        \"type\" : [ \"null\", {\n          \"type\" : \"long\",\n          \"logicalType\" : \"timestamp-millis\"\n        } ],\n        \"default\" : null\n      } ]\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_map\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"map\",\n      \"values\" : [ \"null\", \"int\" ]\n    } ],\n    \"default\" : null\n  }, {\n    \"name\" : \"f_array\",\n    \"type\" : [ \"null\", {\n      \"type\" : \"array\",\n      \"items\" : [ \"null\", \"int\" ]\n    } ],\n    \"default\" : null\n  } ]\n}";
        DataType dataType = AvroSchemaConverter.convertToDataType((String)schemaStr);
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        Assertions.assertThat((Object)schema).isEqualTo((Object)new Schema.Parser().parse(schemaStr));
    }

    @Test
    void testSchemaToDataTypeToSchemaNonNullable() {
        String schemaStr = "{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"namespace\" : \"org.apache.flink.avro.generated\",\n  \"fields\" : [ {\n    \"name\" : \"f_boolean\",\n    \"type\" : \"boolean\"\n  }, {\n    \"name\" : \"f_int\",\n    \"type\" : \"int\"\n  }, {\n    \"name\" : \"f_bigint\",\n    \"type\" : \"long\"\n  }, {\n    \"name\" : \"f_float\",\n    \"type\" : \"float\"\n  }, {\n    \"name\" : \"f_double\",\n    \"type\" : \"double\"\n  }, {\n    \"name\" : \"f_string\",\n    \"type\" : \"string\"\n  }, {\n    \"name\" : \"f_varbinary\",\n    \"type\" : \"bytes\"\n  }, {\n    \"name\" : \"f_timestamp\",\n    \"type\" : {\n      \"type\" : \"long\",\n      \"logicalType\" : \"timestamp-millis\"\n    }\n  }, {\n    \"name\" : \"f_date\",\n    \"type\" : {\n      \"type\" : \"int\",\n      \"logicalType\" : \"date\"\n    }\n  }, {\n    \"name\" : \"f_time\",\n    \"type\" : {\n      \"type\" : \"int\",\n      \"logicalType\" : \"time-millis\"\n    }\n  }, {\n    \"name\" : \"f_decimal\",\n    \"type\" : {\n      \"type\" : \"bytes\",\n      \"logicalType\" : \"decimal\",\n      \"precision\" : 10,\n      \"scale\" : 0\n    }\n  }, {\n    \"name\" : \"f_row\",\n    \"type\" : {\n      \"type\" : \"record\",\n      \"name\" : \"record_f_row\",\n      \"fields\" : [ {\n        \"name\" : \"f0\",\n        \"type\" : \"int\"\n      }, {\n        \"name\" : \"f1\",\n        \"type\" : {\n          \"type\" : \"long\",\n          \"logicalType\" : \"timestamp-millis\"\n        }\n      } ]\n    }\n  }, {\n    \"name\" : \"f_map\",\n    \"type\" : {\n      \"type\" : \"map\",\n      \"values\" : \"int\"\n    }\n  }, {\n    \"name\" : \"f_array\",\n    \"type\" : {\n      \"type\" : \"array\",\n      \"items\" : \"int\"\n    }\n  } ]\n}";
        DataType dataType = AvroSchemaConverter.convertToDataType((String)schemaStr);
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        Assertions.assertThat((Object)schema).isEqualTo((Object)new Schema.Parser().parse(schemaStr));
    }

    @Test
    void testTimestampsSchemaToDataTypeToSchemaLegacyTimestampMapping() {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaStr = ((SpecificRecord)testData.f1).getSchema().toString();
        DataType dataType = AvroSchemaConverter.convertToDataType((String)schemaStr);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 6, it only supports precision less than 3.");
    }

    @Test
    void testTimestampsSchemaToTypeInfoLegacyTimestampMapping() {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaStr = ((SpecificRecord)testData.f1).getSchema().toString();
        TypeInformation typeInfo = AvroSchemaConverter.convertToTypeInfo((String)schemaStr);
        this.validateLegacyTimestampsSchema(typeInfo);
    }

    @Test
    void testTimestampsSchemaToDataTypeToSchemaNewMapping() {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaStr = ((SpecificRecord)testData.f1).getSchema().toString();
        DataType dataType = AvroSchemaConverter.convertToDataType((String)schemaStr, (boolean)false);
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType(), (boolean)false);
        DataType dataType2 = AvroSchemaConverter.convertToDataType((String)schema.toString(), (boolean)false);
        this.validateTimestampsSchema(dataType2);
    }

    @Test
    void testTimestampsSchemaToTypeInfoNewMapping() {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaStr = ((SpecificRecord)testData.f1).getSchema().toString();
        TypeInformation typeInfo = AvroSchemaConverter.convertToTypeInfo((String)schemaStr, (boolean)false);
        this.validateTimestampsSchema(typeInfo);
    }

    private void validateUserSchema(TypeInformation<?> actual) {
        TypeInformation address = Types.ROW_NAMED((String[])new String[]{"num", "street", "city", "state", "zip"}, (TypeInformation[])new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING});
        TypeInformation user = Types.ROW_NAMED((String[])new String[]{"name", "favorite_number", "favorite_color", "type_long_test", "type_double_test", "type_null_test", "type_bool_test", "type_array_string", "type_array_boolean", "type_nullable_array", "type_enum", "type_map", "type_fixed", "type_union", "type_nested", "type_bytes", "type_date", "type_time_millis", "type_time_micros", "type_timestamp_millis", "type_timestamp_micros", "type_decimal_bytes", "type_decimal_fixed"}, (TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT, Types.STRING, Types.LONG, Types.DOUBLE, Types.VOID, Types.BOOLEAN, Types.OBJECT_ARRAY((TypeInformation)Types.STRING), Types.OBJECT_ARRAY((TypeInformation)Types.BOOLEAN), Types.OBJECT_ARRAY((TypeInformation)Types.STRING), Types.STRING, Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.LONG), Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), Types.GENERIC(Object.class), address, Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), Types.SQL_DATE, Types.SQL_TIME, Types.SQL_TIME, Types.SQL_TIMESTAMP, Types.SQL_TIMESTAMP, Types.BIG_DEC, Types.BIG_DEC});
        Assertions.assertThat(actual).isEqualTo((Object)user);
        RowTypeInfo userRowInfo = (RowTypeInfo)user;
        Assertions.assertThat((boolean)userRowInfo.schemaEquals(actual)).isTrue();
    }

    private void validateTimestampsSchema(TypeInformation<?> actual) {
        TypeInformation timestamps = Types.ROW_NAMED((String[])new String[]{"type_timestamp_millis", "type_timestamp_micros", "type_local_timestamp_millis", "type_local_timestamp_micros"}, (TypeInformation[])new TypeInformation[]{Types.INSTANT, Types.INSTANT, Types.LOCAL_DATE_TIME, Types.LOCAL_DATE_TIME});
        RowTypeInfo timestampsRowTypeInfo = (RowTypeInfo)timestamps;
        Assertions.assertThat((boolean)timestampsRowTypeInfo.schemaEquals(actual)).isTrue();
    }

    private void validateLegacyTimestampsSchema(TypeInformation<?> actual) {
        TypeInformation timestamps = Types.ROW_NAMED((String[])new String[]{"type_timestamp_millis", "type_timestamp_micros", "type_local_timestamp_millis", "type_local_timestamp_micros"}, (TypeInformation[])new TypeInformation[]{Types.SQL_TIMESTAMP, Types.SQL_TIMESTAMP, Types.LONG, Types.LONG});
        RowTypeInfo timestampsRowTypeInfo = (RowTypeInfo)timestamps;
        Assertions.assertThat((boolean)timestampsRowTypeInfo.schemaEquals(actual)).isTrue();
    }

    private void validateLegacyTimestampsSchema(DataType actual) {
        DataType timestamps = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"type_timestamp_millis", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), DataTypes.FIELD((String)"type_timestamp_micros", (DataType)((DataType)DataTypes.TIMESTAMP((int)6).notNull())), DataTypes.FIELD((String)"type_local_timestamp_millis", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"type_local_timestamp_micros", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull();
        Assertions.assertThat((Object)actual).isEqualTo((Object)timestamps);
    }

    private void validateTimestampsSchema(DataType actual) {
        DataType timestamps = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"type_timestamp_millis", (DataType)((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull())), DataTypes.FIELD((String)"type_timestamp_micros", (DataType)((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6).notNull())), DataTypes.FIELD((String)"type_local_timestamp_millis", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), DataTypes.FIELD((String)"type_local_timestamp_micros", (DataType)((DataType)DataTypes.TIMESTAMP((int)6).notNull()))}).notNull();
        Assertions.assertThat((Object)actual).isEqualTo((Object)timestamps);
    }

    private void validateUserSchema(DataType actual) {
        DataType address = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"num", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"street", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"city", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"state", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"zip", (DataType)((DataType)DataTypes.STRING().notNull()))});
        DataType user = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"favorite_number", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"favorite_color", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"type_long_test", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"type_double_test", (DataType)((DataType)DataTypes.DOUBLE().notNull())), DataTypes.FIELD((String)"type_null_test", (DataType)DataTypes.NULL()), DataTypes.FIELD((String)"type_bool_test", (DataType)((DataType)DataTypes.BOOLEAN().notNull())), DataTypes.FIELD((String)"type_array_string", (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull())).notNull())), DataTypes.FIELD((String)"type_array_boolean", (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BOOLEAN().notNull())).notNull())), DataTypes.FIELD((String)"type_nullable_array", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull()))), DataTypes.FIELD((String)"type_enum", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"type_map", (DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.BIGINT().notNull())).notNull())), DataTypes.FIELD((String)"type_fixed", (DataType)DataTypes.VARBINARY((int)16)), DataTypes.FIELD((String)"type_union", (DataType)new AtomicDataType((LogicalType)new TypeInformationRawType(false, Types.GENERIC(Object.class)), Object.class)), DataTypes.FIELD((String)"type_nested", (DataType)address), DataTypes.FIELD((String)"type_bytes", (DataType)((DataType)DataTypes.BYTES().notNull())), DataTypes.FIELD((String)"type_date", (DataType)((DataType)DataTypes.DATE().notNull())), DataTypes.FIELD((String)"type_time_millis", (DataType)((DataType)DataTypes.TIME((int)3).notNull())), DataTypes.FIELD((String)"type_time_micros", (DataType)((DataType)DataTypes.TIME((int)6).notNull())), DataTypes.FIELD((String)"type_timestamp_millis", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), DataTypes.FIELD((String)"type_timestamp_micros", (DataType)((DataType)DataTypes.TIMESTAMP((int)6).notNull())), DataTypes.FIELD((String)"type_decimal_bytes", (DataType)((DataType)DataTypes.DECIMAL((int)4, (int)2).notNull())), DataTypes.FIELD((String)"type_decimal_fixed", (DataType)((DataType)DataTypes.DECIMAL((int)4, (int)2).notNull()))}).notNull();
        Assertions.assertThat((Object)actual).isEqualTo((Object)user);
    }
}

