/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.util.JarUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class AvroExternalJarProgramITCase {
    private static final String JAR_FILE = "maven-test-jar.jar";
    private static final String TEST_DATA_FILE = "/testdata.avro";
    private static final int PARALLELISM = 4;
    private static final MiniCluster MINI_CLUSTER = new MiniCluster(new MiniClusterConfiguration.Builder().withRandomPorts().setNumTaskManagers(1).setNumSlotsPerTaskManager(4).build());

    AvroExternalJarProgramITCase() {
    }

    @BeforeAll
    static void setUp() throws Exception {
        MINI_CLUSTER.start();
    }

    @AfterAll
    static void tearDown() {
        TestStreamEnvironment.unsetAsContext();
        MINI_CLUSTER.closeAsync();
    }

    @Test
    void testExternalProgram() throws Exception {
        String jarFile = JAR_FILE;
        try {
            JarUtils.checkJarFile((URL)new File(jarFile).getAbsoluteFile().toURI().toURL());
        }
        catch (IOException e) {
            jarFile = "target/".concat(jarFile);
        }
        TestStreamEnvironment.setAsContext((MiniCluster)MINI_CLUSTER, (int)4, Collections.singleton(new Path(jarFile)), Collections.emptyList());
        String testData = this.getClass().getResource(TEST_DATA_FILE).toString();
        PackagedProgram program = PackagedProgram.newBuilder().setJarFile(new File(jarFile)).setArguments(new String[]{testData}).build();
        program.invokeInteractiveModeForExecution();
    }
}

