/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.time.Instant;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.avro.AvroDeserializationSchema;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.UnionLogicalType;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class AvroDeserializationSchemaTest {
    private static final Address address = TestDataGenerator.generateRandomAddress(new Random());

    AvroDeserializationSchemaTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testNullRecord(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroDeserializationSchema deserializer = AvroDeserializationSchema.forSpecific(Address.class, (AvroFormatOptions.AvroEncoding)encoding);
        Address deserializedAddress = (Address)((Object)deserializer.deserialize(null));
        Assertions.assertThat((Comparable)((Object)deserializedAddress)).isNull();
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testGenericRecord(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroDeserializationSchema deserializationSchema = AvroDeserializationSchema.forGeneric((Schema)address.getSchema(), (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedAddress = AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema(), encoding);
        GenericRecord genericRecord = (GenericRecord)deserializationSchema.deserialize(encodedAddress);
        Assertions.assertThat((String)genericRecord.get("city").toString()).isEqualTo((Object)address.getCity());
        Assertions.assertThat((Object)genericRecord.get("num")).isEqualTo((Object)address.getNum());
        Assertions.assertThat((String)genericRecord.get("state").toString()).isEqualTo((Object)address.getState());
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificRecord(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroDeserializationSchema deserializer = AvroDeserializationSchema.forSpecific(Address.class, (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedAddress = AvroTestUtils.writeRecord(address, encoding);
        Address deserializedAddress = (Address)((Object)deserializer.deserialize(encodedAddress));
        Assertions.assertThat((Comparable)((Object)deserializedAddress)).isEqualTo((Object)address);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificRecordWithUnionLogicalType(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        Random rnd = new Random();
        UnionLogicalType data = new UnionLogicalType(Instant.ofEpochMilli(rnd.nextLong()));
        AvroDeserializationSchema deserializer = AvroDeserializationSchema.forSpecific(UnionLogicalType.class, (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedData = AvroTestUtils.writeRecord(data, encoding);
        UnionLogicalType deserializedData = (UnionLogicalType)((Object)deserializer.deserialize(encodedData));
        Assertions.assertThat((Comparable)((Object)deserializedData)).isEqualTo((Object)data);
    }
}

