/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import io.undertow.util.URLUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.undertow.handlers.CamelMethodHandler;
import org.apache.camel.component.undertow.handlers.CamelPathHandler;
import org.apache.camel.component.undertow.handlers.CamelPathTemplateHandler;

public class CamelRootHandler
implements HttpHandler {
    private final Lock lock = new ReentrantLock();
    private final CamelPathHandler pathHandler;

    public CamelRootHandler(HttpHandler defaultHandler) {
        this.pathHandler = new CamelPathHandler(defaultHandler);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.pathHandler.handleRequest(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpHandler add(String path, String methods, boolean prefixMatch, HttpHandler handler) {
        this.lock.lock();
        try {
            CamelMethodHandler targetHandler;
            String basePath = this.getBasePath(path);
            HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
            if (path.contains("{")) {
                String relativePath = path.substring(basePath.length());
                if (basePathHandler instanceof CamelPathTemplateHandler) {
                    CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                    targetHandler = templateHandler.get(relativePath);
                    if (targetHandler == null) {
                        targetHandler = new CamelMethodHandler();
                        templateHandler.add(relativePath, targetHandler);
                    }
                } else {
                    targetHandler = this.add(basePathHandler, relativePath, basePath);
                }
            } else if (basePathHandler instanceof CamelPathTemplateHandler) {
                CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                if (prefixMatch) throw new IllegalArgumentException(String.format("Duplicate handlers on a path '%s'", path));
                targetHandler = templateHandler.getDefault();
            } else if (basePathHandler instanceof CamelMethodHandler) {
                targetHandler = (CamelMethodHandler)basePathHandler;
            } else {
                if (basePathHandler != null) throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
                targetHandler = new CamelMethodHandler();
                if (prefixMatch) {
                    this.pathHandler.addPrefixPath(basePath, targetHandler);
                } else {
                    this.pathHandler.addExactPath(basePath, targetHandler);
                }
            }
            HttpHandler httpHandler = targetHandler.add(methods, handler);
            return httpHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    private CamelMethodHandler add(HttpHandler basePathHandler, String relativePath, String basePath) {
        CamelPathTemplateHandler templateHandler;
        if (basePathHandler instanceof CamelMethodHandler) {
            templateHandler = new CamelPathTemplateHandler((CamelMethodHandler)basePathHandler);
        } else if (basePathHandler == null) {
            templateHandler = new CamelPathTemplateHandler(new CamelMethodHandler());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
        }
        CamelMethodHandler targetHandler = new CamelMethodHandler();
        templateHandler.add(relativePath, targetHandler);
        this.pathHandler.addPrefixPath(basePath, templateHandler);
        return targetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path, String methods, boolean prefixMatch) {
        this.lock.lock();
        try {
            String basePath = this.getBasePath(path);
            HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
            if (basePathHandler == null) {
                return;
            }
            if (path.contains("{")) {
                CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                String relativePath = path.substring(basePath.length());
                CamelMethodHandler targetHandler = templateHandler.get(relativePath);
                if (targetHandler.remove(methods)) {
                    templateHandler.remove(relativePath);
                    if (templateHandler.isEmpty()) {
                        this.pathHandler.removePrefixPath(basePath);
                    }
                }
            } else if (basePathHandler instanceof CamelPathTemplateHandler) {
                String relativePath = path.substring(basePath.length());
                CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                CamelMethodHandler targetHandler = templateHandler.getDefault();
                if (targetHandler.remove(methods)) {
                    templateHandler.remove(relativePath);
                    if (templateHandler.isEmpty()) {
                        this.pathHandler.removePrefixPath(basePath);
                    }
                }
            } else {
                CamelMethodHandler targetHandler = (CamelMethodHandler)basePathHandler;
                if (targetHandler.remove(methods)) {
                    if (prefixMatch) {
                        this.pathHandler.removePrefixPath(basePath);
                    } else {
                        this.pathHandler.removeExactPath(basePath);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.pathHandler.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.pathHandler.toString();
    }

    private String getBasePath(String path) {
        if (path.contains("{")) {
            path = PathTemplate.create((String)path).getBase();
        }
        return URLUtils.normalizeSlashes((String)path);
    }
}

