/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CamelPathHandler
extends PathHandler {
    private final Lock lock = new ReentrantLock();
    private final Map<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
    private String handlerString;

    public CamelPathHandler(HttpHandler defaultHandler) {
        super(defaultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathHandler addPrefixPath(String path, HttpHandler handler) {
        this.lock.lock();
        try {
            super.addPrefixPath(path, handler);
            this.handlers.put(path, handler);
            this.handlerString = null;
            CamelPathHandler camelPathHandler = this;
            return camelPathHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathHandler addExactPath(String path, HttpHandler handler) {
        this.lock.lock();
        try {
            super.addExactPath(path, handler);
            this.handlers.put(path, handler);
            this.handlerString = null;
            CamelPathHandler camelPathHandler = this;
            return camelPathHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PathHandler removePrefixPath(String path) {
        this.lock.lock();
        try {
            super.removePrefixPath(path);
            this.handlers.remove(path);
            this.handlerString = null;
            CamelPathHandler camelPathHandler = this;
            return camelPathHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PathHandler removeExactPath(String path) {
        this.lock.lock();
        try {
            super.removeExactPath(path);
            this.handlers.remove(path);
            this.handlerString = null;
            CamelPathHandler camelPathHandler = this;
            return camelPathHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpHandler getHandler(String path) {
        return this.handlers.get(path);
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelPathHandler[" + this.handlers + "]";
        }
        return this.handlerString;
    }
}

