/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.handlers.RestConsumerPath;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class RestRootHandler
implements HttpHandler {
    private static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "OPTIONS", "CONNECT", "PATCH");
    private final Set<UndertowConsumer> consumers = new CopyOnWriteArraySet<UndertowConsumer>();
    private String token;
    private int len;

    public void init(int port) {
        this.token = ":" + port;
        this.len = this.token.length();
    }

    public void addConsumer(UndertowConsumer consumer) {
        this.consumers.add(consumer);
        RestConsumerContextPathMatcher.register((String)consumer.getEndpoint().getHttpURI().getPath());
    }

    public void removeConsumer(UndertowConsumer consumer) {
        this.consumers.remove((Object)consumer);
        RestConsumerContextPathMatcher.unRegister((String)consumer.getEndpoint().getHttpURI().getPath());
    }

    public int consumers() {
        return this.consumers.size();
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        String method = httpServerExchange.getRequestMethod().toString();
        HttpHandler handler = this.getHandler(httpServerExchange, method);
        if (handler != null) {
            handler.handleRequest(httpServerExchange);
        } else {
            boolean hasAnyMethod = METHODS.stream().anyMatch(m -> this.isHttpMethodAllowed(httpServerExchange, (String)m));
            if (hasAnyMethod) {
                httpServerExchange.setStatusCode(405);
                httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                httpServerExchange.getResponseSender().send("Method not allowed");
            } else {
                httpServerExchange.setStatusCode(404);
                httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                httpServerExchange.getResponseSender().send("No matching path found");
            }
        }
    }

    private HttpHandler getHandler(HttpServerExchange httpServerExchange, String method) {
        HttpHandler answer = null;
        if (method == null) {
            return null;
        }
        String path = httpServerExchange.getRequestURI();
        int idx = path.indexOf(this.token);
        if (idx > -1) {
            path = path.substring(idx + this.len);
        }
        path = RestRootHandler.pathAsKey(path);
        ArrayList<RestConsumerPath> paths = new ArrayList<RestConsumerPath>();
        for (UndertowConsumer consumer : this.consumers) {
            paths.add(new RestConsumerPath(consumer));
        }
        RestConsumerContextPathMatcher.ConsumerPath best = RestConsumerContextPathMatcher.matchBestPath((String)method, (String)path, paths);
        if (best != null) {
            answer = (HttpHandler)best.getConsumer();
        }
        List<Object> candidates = new ArrayList();
        if (answer == null) {
            for (UndertowConsumer consumer : this.consumers) {
                boolean matchOnUriPrefix;
                String consumerPath = consumer.getEndpoint().getHttpURI().getPath();
                if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = consumer.getEndpoint().isMatchOnUriPrefix()))) continue;
                candidates.add((Object)consumer);
            }
        }
        if ((candidates = candidates.stream().filter(c -> RestRootHandler.matchRestMethod(method, c.getEndpoint().getHttpMethodRestrict())).collect(Collectors.toList())).size() == 1) {
            answer = (HttpHandler)candidates.get(0);
        }
        return answer;
    }

    private static String pathAsKey(String path) {
        if (path == null || path.equals("/")) {
            path = "";
        }
        if ((path = StringHelper.before((String)path, (String)"?", (String)path)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return UnsafeUriCharactersEncoder.encodeHttpURI((String)path);
    }

    private static boolean matchRestMethod(String method, String restrict) {
        return restrict == null || restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }

    private boolean isHttpMethodAllowed(HttpServerExchange httpServerExchange, String method) {
        return this.getHandler(httpServerExchange, method) != null;
    }
}

