/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.telegram.model.InlineKeyboardButton;
import org.apache.camel.component.telegram.model.ReplyMarkup;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReplyKeyboardMarkup
implements Serializable,
ReplyMarkup {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="one_time_keyboard")
    private Boolean oneTimeKeyboard;
    @JsonProperty(value="remove_keyboard")
    private Boolean removeKeyboard;
    @JsonProperty(value="resize_keyboard")
    private Boolean resizeKeyboard;
    private Boolean selective;
    private List<List<InlineKeyboardButton>> keyboard;

    public ReplyKeyboardMarkup() {
    }

    public ReplyKeyboardMarkup(Boolean oneTimeKeyboard, Boolean removeKeyboard, Boolean resizeKeyboard, Boolean selective, List<List<InlineKeyboardButton>> keyboard) {
        this.oneTimeKeyboard = oneTimeKeyboard;
        this.removeKeyboard = removeKeyboard;
        this.resizeKeyboard = resizeKeyboard;
        this.selective = selective;
        this.keyboard = keyboard;
    }

    public Boolean getOneTimeKeyboard() {
        return this.oneTimeKeyboard;
    }

    public void setOneTimeKeyboard(Boolean oneTimeKeyboard) {
        this.oneTimeKeyboard = oneTimeKeyboard;
    }

    public Boolean getRemoveKeyboard() {
        return this.removeKeyboard;
    }

    public void setRemoveKeyboard(Boolean removeKeyboard) {
        this.removeKeyboard = removeKeyboard;
    }

    public List<List<InlineKeyboardButton>> getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(List<List<InlineKeyboardButton>> keyboard) {
        this.keyboard = keyboard;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplyKeyboardMarkup{");
        sb.append("oneTimeKeyboard='").append(this.oneTimeKeyboard).append('\'');
        sb.append(", keyboard='").append(this.keyboard);
        sb.append('}');
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Boolean getResizeKeyboard() {
        return this.resizeKeyboard;
    }

    public void setResizeKeyboard(Boolean resizeKeyboard) {
        this.resizeKeyboard = resizeKeyboard;
    }

    public Boolean getSelective() {
        return this.selective;
    }

    public void setSelective(Boolean selective) {
        this.selective = selective;
    }

    public static class Builder {
        private Boolean oneTimeKeyboard;
        private Boolean removeKeyboard;
        private Boolean resizeKeyboard;
        private Boolean selective;
        private List<List<InlineKeyboardButton>> keyboard;

        public Builder oneTimeKeyboard(Boolean oneTimeKeyboard) {
            this.oneTimeKeyboard = oneTimeKeyboard;
            return this;
        }

        public Builder removeKeyboard(Boolean removeKeyboard) {
            this.removeKeyboard = removeKeyboard;
            return this;
        }

        public Builder resizeKeyboard(Boolean resizeKeyboard) {
            this.resizeKeyboard = resizeKeyboard;
            return this;
        }

        public Builder selective(Boolean selective) {
            this.selective = selective;
            return this;
        }

        public ReplyKeyboardMarkup build() {
            return new ReplyKeyboardMarkup(this.oneTimeKeyboard, this.removeKeyboard, this.resizeKeyboard, this.selective, this.keyboard);
        }

        public KeyboardBuilder keyboard() {
            return new KeyboardBuilder(this);
        }

        public static class KeyboardBuilder {
            private Builder builder;
            private List<List<InlineKeyboardButton>> keyboard;

            public KeyboardBuilder(Builder builder) {
                this.builder = builder;
                this.keyboard = new ArrayList<List<InlineKeyboardButton>>();
            }

            public KeyboardBuilder addRow(List<InlineKeyboardButton> inlineKeyboardButtons) {
                this.keyboard.add(inlineKeyboardButtons);
                return this;
            }

            public KeyboardBuilder addOneRowByEachButton(List<InlineKeyboardButton> inlineKeyboardButtons) {
                Iterator<InlineKeyboardButton> iterator = inlineKeyboardButtons.iterator();
                while (iterator.hasNext()) {
                    this.keyboard.add(Arrays.asList(iterator.next()));
                }
                return this;
            }

            public Builder close() {
                this.builder.keyboard = this.keyboard;
                return this.builder;
            }
        }
    }
}

