/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public abstract class RoutePolicySupport
extends ServiceSupport
implements RoutePolicy {
    private ExceptionHandler exceptionHandler;

    public void onInit(Route route) {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(route.getCamelContext(), ((Object)((Object)this)).getClass());
        }
    }

    public void onRemove(Route route) {
    }

    public void onStart(Route route) {
    }

    public void onStop(Route route) {
    }

    public void onSuspend(Route route) {
    }

    public void onResume(Route route) {
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
    }

    public void onExchangeDone(Route route, Exchange exchange) {
    }

    public void startConsumer(Consumer consumer) throws Exception {
        ServiceHelper.startService((Service)consumer);
    }

    public void stopConsumer(Consumer consumer) throws Exception {
        ServiceHelper.stopService((Service)consumer);
    }

    public boolean suspendOrStopConsumer(Consumer consumer) throws Exception {
        return ServiceHelper.suspendService((Object)consumer);
    }

    public boolean resumeOrStartConsumer(Consumer consumer) throws Exception {
        return ServiceHelper.resumeService((Object)consumer);
    }

    public void startRoute(Route route) throws Exception {
        this.controller(route).startRoute(route.getId());
    }

    public void resumeRoute(Route route) throws Exception {
        this.controller(route).resumeRoute(route.getId());
    }

    public void suspendRoute(Route route) throws Exception {
        this.controller(route).suspendRoute(route.getId());
    }

    public void suspendRoute(Route route, long timeout, TimeUnit timeUnit) throws Exception {
        this.controller(route).suspendRoute(route.getId(), timeout, timeUnit);
    }

    public void stopRoute(Route route) throws Exception {
        this.controller(route).stopRoute(route.getId());
    }

    public void stopRoute(Route route, long timeout, TimeUnit timeUnit) throws Exception {
        this.controller(route).stopRoute(route.getId(), timeout, timeUnit);
    }

    public void stopRouteAsync(Route route) {
        String threadId = route.getCamelContext().getExecutorServiceManager().resolveThreadName("StopRouteAsync");
        Runnable task = () -> {
            try {
                this.controller(route).stopRoute(route.getId());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        };
        new Thread(task, threadId).start();
    }

    protected RouteController controller(Route route) {
        return route.getCamelContext().getRouteController();
    }

    protected void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(t);
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

