/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.util.ObjectHelper;

public class FileStartupCondition
implements StartupCondition {
    private final File file;

    public FileStartupCondition(String name) {
        ObjectHelper.notNullOrEmpty((String)name, (String)"File");
        this.file = new File(name);
    }

    public String getName() {
        return "File";
    }

    public String getWaitMessage() {
        return "Waiting for file: " + this.file;
    }

    public String getFailureMessage() {
        return "File: " + this.file + " does not exist";
    }

    protected boolean fileExists(File file) {
        return file.exists();
    }

    public boolean canContinue(CamelContext camelContext) throws Exception {
        return this.fileExists(this.file);
    }
}

