/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk.support;

import com.splunk.Args;
import com.splunk.Service;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.event.SplunkEvent;
import org.apache.camel.component.splunk.support.DataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SplunkDataWriter
implements DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkDataWriter.class);
    protected SplunkEndpoint endpoint;
    protected Args args;
    private boolean connected;
    private Socket socket;
    protected final Lock lock = new ReentrantLock();

    public SplunkDataWriter(SplunkEndpoint endpoint, Args args) {
        this.endpoint = endpoint;
        this.args = args;
    }

    protected abstract Socket createSocket(Service var1) throws IOException;

    @Override
    public void write(SplunkEvent event) throws Exception {
        this.doWrite(event.toString());
    }

    @Override
    public void write(String event) throws Exception {
        this.doWrite(event + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(String event) throws IOException {
        this.lock.lock();
        try {
            LOG.debug("writing event to splunk:{}", (Object)event);
            OutputStream ostream = this.socket.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(ostream, StandardCharsets.UTF_8);
            writer.write(event);
            ((Writer)writer).flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        this.lock.lock();
        try {
            this.socket = this.createSocket(this.endpoint.getService());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.socket != null) {
                this.socket.close();
                this.connected = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

