/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience4j;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.resilience4j.ResilienceProcessor;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="resilience4j", displayName="Resilience Circuit Breaker", description="Display circuit breaker information")
public class ResilienceConsole
extends AbstractDevConsole {
    public ResilienceConsole() {
        super("camel", "resilience4j", "Resilience Circuit Breaker", "Display circuit breaker information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ResilienceProcessor> cbs = new ArrayList<ResilienceProcessor>();
        for (Route route : this.getCamelContext().getRoutes()) {
            List list = route.filter("*");
            for (Processor p : list) {
                if (!(p instanceof ResilienceProcessor)) continue;
                cbs.add((ResilienceProcessor)p);
            }
        }
        cbs.sort(Comparator.comparing(ResilienceProcessor::getId));
        for (ResilienceProcessor cb : cbs) {
            String id = cb.getId();
            String rid = cb.getRouteId();
            String state = cb.getCircuitBreakerState();
            int sc = cb.getNumberOfSuccessfulCalls();
            int bc = cb.getNumberOfBufferedCalls();
            int fc = cb.getNumberOfFailedCalls();
            long npc = cb.getNumberOfNotPermittedCalls();
            float fr = cb.getFailureRate();
            if (fr > 0.0f) {
                sb.append(String.format("    %s/%s: %s (buffered: %d success: %d failure: %d/%.0f%% not-permitted: %d)\n", rid, id, state, bc, sc, fc, Float.valueOf(fr), npc));
                continue;
            }
            sb.append(String.format("    %s/%s: %s (buffered: %d success: %d failure: 0 not-permitted: %d)\n", rid, id, state, bc, sc, npc));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<ResilienceProcessor> cbs = new ArrayList<ResilienceProcessor>();
        for (Route route : this.getCamelContext().getRoutes()) {
            List list = route.filter("*");
            for (Processor p : list) {
                if (!(p instanceof ResilienceProcessor)) continue;
                cbs.add((ResilienceProcessor)p);
            }
        }
        cbs.sort(Comparator.comparing(ResilienceProcessor::getId));
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (ResilienceProcessor cb : cbs) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"id", (Object)cb.getId());
            jo.put((Object)"routeId", (Object)cb.getRouteId());
            jo.put((Object)"state", (Object)cb.getCircuitBreakerState());
            jo.put((Object)"bufferedCalls", (Object)cb.getNumberOfBufferedCalls());
            jo.put((Object)"successfulCalls", (Object)cb.getNumberOfSuccessfulCalls());
            jo.put((Object)"failedCalls", (Object)cb.getNumberOfFailedCalls());
            jo.put((Object)"notPermittedCalls", (Object)cb.getNumberOfNotPermittedCalls());
            jo.put((Object)"failureRate", (Object)Float.valueOf(cb.getFailureRate()));
            list.add(jo);
        }
        root.put((Object)"circuitBreakers", list);
        return root;
    }
}

