/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.PulsarMessageListener;
import org.apache.camel.util.ObjectHelper;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.MessageListener;

public final class CommonCreationStrategyImpl {
    private CommonCreationStrategyImpl() {
    }

    protected static ConsumerBuilder<byte[]> getBuilder(String name, PulsarEndpoint pulsarEndpoint, PulsarConsumer pulsarConsumer) {
        PulsarConfiguration endpointConfiguration = pulsarEndpoint.getPulsarConfiguration();
        ConsumerBuilder builder = pulsarEndpoint.getPulsarClient().newConsumer();
        if (endpointConfiguration.getKeySharedPolicy() != null) {
            if ("AUTO_SPLIT".equalsIgnoreCase(endpointConfiguration.getKeySharedPolicy())) {
                builder.keySharedPolicy((KeySharedPolicy)KeySharedPolicy.autoSplitHashRange());
            } else if ("STICKY".equalsIgnoreCase(endpointConfiguration.getKeySharedPolicy())) {
                builder.keySharedPolicy((KeySharedPolicy)KeySharedPolicy.stickyHashRange());
            } else {
                throw new IllegalArgumentException("Unsupported KeySharedPolicy: " + endpointConfiguration.getKeySharedPolicy());
            }
        }
        if (endpointConfiguration.isTopicsPattern()) {
            builder.topicsPattern(pulsarEndpoint.getUri());
            if (endpointConfiguration.getSubscriptionTopicsMode() != null) {
                builder.subscriptionTopicsMode(endpointConfiguration.getSubscriptionTopicsMode());
            }
        } else {
            builder.topic(new String[]{pulsarEndpoint.getUri()});
        }
        builder.subscriptionName(endpointConfiguration.getSubscriptionName()).receiverQueueSize(endpointConfiguration.getConsumerQueueSize()).consumerName(name).ackTimeout(endpointConfiguration.getAckTimeoutMillis(), TimeUnit.MILLISECONDS).subscriptionInitialPosition(endpointConfiguration.getSubscriptionInitialPosition().toPulsarSubscriptionInitialPosition()).acknowledgmentGroupTime(endpointConfiguration.getAckGroupTimeMillis(), TimeUnit.MILLISECONDS).negativeAckRedeliveryDelay(endpointConfiguration.getNegativeAckRedeliveryDelayMicros(), TimeUnit.MICROSECONDS).readCompacted(endpointConfiguration.isReadCompacted());
        if (endpointConfiguration.isMessageListener()) {
            builder.messageListener((MessageListener)new PulsarMessageListener(pulsarEndpoint, pulsarConsumer));
        }
        if (endpointConfiguration.isEnableRetry()) {
            builder.enableRetry(true);
            DeadLetterPolicy.DeadLetterPolicyBuilder policy = DeadLetterPolicy.builder().maxRedeliverCount(endpointConfiguration.getMaxRedeliverCount().intValue());
            if (endpointConfiguration.getRetryLetterTopic() != null) {
                policy.retryLetterTopic(endpointConfiguration.getRetryLetterTopic());
            }
            builder.deadLetterPolicy(policy.build());
        } else if (endpointConfiguration.getMaxRedeliverCount() != null) {
            DeadLetterPolicy.DeadLetterPolicyBuilder policy = DeadLetterPolicy.builder().maxRedeliverCount(endpointConfiguration.getMaxRedeliverCount().intValue());
            if (endpointConfiguration.getDeadLetterTopic() != null) {
                policy.deadLetterTopic(endpointConfiguration.getDeadLetterTopic());
            }
            builder.deadLetterPolicy(policy.build());
        }
        if (ObjectHelper.isNotEmpty((Object)endpointConfiguration.getAckTimeoutRedeliveryBackoff())) {
            builder.ackTimeoutRedeliveryBackoff(endpointConfiguration.getAckTimeoutRedeliveryBackoff());
        }
        if (ObjectHelper.isNotEmpty((Object)endpointConfiguration.getNegativeAckRedeliveryBackoff())) {
            builder.negativeAckRedeliveryBackoff(endpointConfiguration.getNegativeAckRedeliveryBackoff());
        }
        return builder;
    }
}

