/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main.authentication;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import org.apache.camel.component.platform.http.main.authentication.MainAuthenticationConfigurer;
import org.apache.camel.component.platform.http.vertx.auth.AuthenticationConfig;
import org.apache.camel.main.HttpManagementServerConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.util.ObjectHelper;

public class JWTAuthenticationConfigurer
implements MainAuthenticationConfigurer {
    @Override
    public void configureAuthentication(AuthenticationConfig authenticationConfig, HttpServerConfigurationProperties properties) {
        String path;
        String string = path = ObjectHelper.isNotEmpty((String)properties.getAuthenticationPath()) ? properties.getAuthenticationPath() : properties.getPath();
        if ("/".equals(path)) {
            path = "/*";
        }
        final String realm = properties.getAuthenticationRealm() != null ? properties.getAuthenticationRealm() : null;
        AuthenticationConfig.AuthenticationConfigEntry entry = new AuthenticationConfig.AuthenticationConfigEntry();
        entry.setPath(path);
        entry.setAuthenticationHandlerFactory(new AuthenticationConfig.AuthenticationHandlerFactory(){

            public <T extends AuthenticationProvider> AuthenticationHandler createAuthenticationHandler(T authenticationProvider) {
                JWTAuth authProvider = (JWTAuth)authenticationProvider;
                return JWTAuthHandler.create((JWTAuth)authProvider, (String)realm);
            }
        });
        entry.setAuthenticationProviderFactory(vertx -> JWTAuth.create((Vertx)vertx, (JWTAuthOptions)new JWTAuthOptions(new JsonObject().put("keyStore", (Object)new JsonObject().put("type", (Object)properties.getJwtKeystoreType()).put("path", (Object)properties.getJwtKeystorePath()).put("password", (Object)properties.getJwtKeystorePassword())))));
        authenticationConfig.getEntries().add(entry);
        authenticationConfig.setEnabled(true);
    }

    @Override
    public void configureAuthentication(AuthenticationConfig authenticationConfig, HttpManagementServerConfigurationProperties properties) {
        String path;
        String string = path = ObjectHelper.isNotEmpty((String)properties.getAuthenticationPath()) ? properties.getAuthenticationPath() : properties.getPath();
        if ("/".equals(path)) {
            path = "/*";
        }
        final String realm = properties.getAuthenticationRealm() != null ? properties.getAuthenticationRealm() : null;
        AuthenticationConfig.AuthenticationConfigEntry entry = new AuthenticationConfig.AuthenticationConfigEntry();
        entry.setPath(path);
        entry.setAuthenticationHandlerFactory(new AuthenticationConfig.AuthenticationHandlerFactory(){

            public <T extends AuthenticationProvider> AuthenticationHandler createAuthenticationHandler(T authenticationProvider) {
                JWTAuth authProvider = (JWTAuth)authenticationProvider;
                return JWTAuthHandler.create((JWTAuth)authProvider, (String)realm);
            }
        });
        entry.setAuthenticationProviderFactory(vertx -> JWTAuth.create((Vertx)vertx, (JWTAuthOptions)new JWTAuthOptions(new JsonObject().put("keyStore", (Object)new JsonObject().put("type", (Object)properties.getJwtKeystoreType()).put("path", (Object)properties.getJwtKeystorePath()).put("password", (Object)properties.getJwtKeystorePassword())))));
        authenticationConfig.getEntries().add(entry);
        authenticationConfig.setEnabled(true);
    }
}

