/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategyDefault;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;

public class MicrometerExchangeEventNotifier
extends AbstractMicrometerEventNotifier<CamelEvent.ExchangeEvent> {
    private static AtomicLong lastExchangeTimestampHolder = new AtomicLong(0L);
    private InflightRepository inflightRepository;
    private final Map<String, Meter> meterMap = new HashMap<String, Meter>();
    private Predicate<Exchange> ignoreExchanges = exchange -> false;
    private MicrometerExchangeEventNotifierNamingStrategy namingStrategy;
    boolean registerKamelets;
    boolean registerTemplates = true;
    boolean baseEndpointURI = true;

    public MicrometerExchangeEventNotifier() {
        super(CamelEvent.ExchangeEvent.class);
    }

    public void setBaseEndpointURI(boolean baseEndpointURI) {
        this.baseEndpointURI = baseEndpointURI;
    }

    public boolean isBaseEndpointURI() {
        return this.baseEndpointURI;
    }

    public void setIgnoreExchanges(Predicate<Exchange> ignoreExchanges) {
        this.ignoreExchanges = ignoreExchanges;
    }

    public Predicate<Exchange> getIgnoreExchanges() {
        return this.ignoreExchanges;
    }

    public MicrometerExchangeEventNotifierNamingStrategy getNamingStrategy() {
        if (this.namingStrategy == null) {
            this.namingStrategy = new MicrometerExchangeEventNotifierNamingStrategyDefault(this.isBaseEndpointURI());
        }
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected void doInit() throws Exception {
        ManagementStrategy ms = this.getCamelContext().getManagementStrategy();
        if (ms != null && ms.getManagementAgent() != null) {
            this.registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
            this.registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.inflightRepository = this.getCamelContext().getInflightRepository();
        this.getCamelContext().getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                if (event instanceof CamelEvent.RouteAddedEvent) {
                    CamelEvent.RouteAddedEvent rre = (CamelEvent.RouteAddedEvent)event;
                    MicrometerExchangeEventNotifier.this.addInflightMeter(rre.getRoute());
                } else if (event instanceof CamelEvent.RouteRemovedEvent) {
                    CamelEvent.RouteRemovedEvent rre = (CamelEvent.RouteRemovedEvent)event;
                    MicrometerExchangeEventNotifier.this.removeInflightMeter(rre.getRoute().getRouteId());
                }
            }
        });
        for (Route route : this.getCamelContext().getRoutes()) {
            this.addInflightMeter(route);
        }
    }

    private void addInflightMeter(Route route) {
        boolean skip;
        boolean bl = skip = route.isCreatedByKamelet() && !this.registerKamelets || route.isCreatedByRouteTemplate() && !this.registerTemplates;
        if (!skip) {
            String routeId = route.getRouteId();
            String name = this.getNamingStrategy().getInflightExchangesName();
            Tags tags = this.getNamingStrategy().getInflightExchangesTags(this.getCamelContext(), routeId);
            Gauge meter = Gauge.builder((String)name, () -> this.inflightRepository.size(routeId)).description("Route inflight messages").tags((Iterable)tags).register(this.getMeterRegistry());
            this.meterMap.put(routeId, (Meter)meter);
        }
    }

    private void removeInflightMeter(String routeId) {
        Meter meter = this.meterMap.remove(routeId);
        if (meter != null) {
            this.getMeterRegistry().remove(meter);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.meterMap.values().forEach(m -> this.getMeterRegistry().remove(m));
        this.meterMap.clear();
    }

    public void notify(CamelEvent eventObject) {
        if (eventObject instanceof CamelEvent.ExchangeEvent) {
            Route route;
            CamelEvent.ExchangeEvent ee = (CamelEvent.ExchangeEvent)eventObject;
            boolean skip = false;
            String routeId = eventObject instanceof CamelEvent.ExchangeCreatedEvent ? ee.getExchange().getFromRouteId() : ExchangeHelper.getAtRouteId((Exchange)ee.getExchange());
            if (routeId != null && (route = ee.getExchange().getContext().getRoute(routeId)) != null) {
                boolean bl = skip = route.isCreatedByKamelet() && !this.registerKamelets || route.isCreatedByRouteTemplate() && !this.registerTemplates;
            }
            if (skip) {
                return;
            }
            if (!this.getIgnoreExchanges().test(ee.getExchange())) {
                if (eventObject instanceof CamelEvent.ExchangeCreatedEvent) {
                    this.handleCreatedEvent((CamelEvent.ExchangeCreatedEvent)eventObject);
                } else if (eventObject instanceof CamelEvent.ExchangeSentEvent) {
                    this.handleSentEvent((CamelEvent.ExchangeSentEvent)eventObject);
                } else if (eventObject instanceof CamelEvent.ExchangeCompletedEvent || eventObject instanceof CamelEvent.ExchangeFailedEvent) {
                    this.handleDoneEvent((CamelEvent.ExchangeEvent)eventObject);
                }
            }
        }
    }

    protected void handleSentEvent(CamelEvent.ExchangeSentEvent sentEvent) {
        String name = this.getNamingStrategy().getName(sentEvent.getExchange(), sentEvent.getEndpoint());
        Tags tags = this.getNamingStrategy().getTags((CamelEvent.ExchangeEvent)sentEvent, sentEvent.getEndpoint());
        Timer timer = Timer.builder((String)name).tags((Iterable)tags).description("Time taken to send message to the endpoint").register(this.getMeterRegistry());
        timer.record(sentEvent.getTimeTaken(), TimeUnit.MILLISECONDS);
    }

    protected void handleCreatedEvent(CamelEvent.ExchangeCreatedEvent createdEvent) {
        String name = this.getNamingStrategy().getName(createdEvent.getExchange(), createdEvent.getExchange().getFromEndpoint());
        createdEvent.getExchange().setProperty("eventTimer:" + name, (Object)Timer.start((MeterRegistry)this.getMeterRegistry()));
    }

    protected void handleDoneEvent(CamelEvent.ExchangeEvent doneEvent) {
        String name = this.getNamingStrategy().getName(doneEvent.getExchange(), doneEvent.getExchange().getFromEndpoint());
        Tags tags = this.getNamingStrategy().getTags(doneEvent, doneEvent.getExchange().getFromEndpoint());
        Timer.Sample sample = (Timer.Sample)doneEvent.getExchange().removeProperty("eventTimer:" + name);
        if (sample != null) {
            sample.stop(this.getMeterRegistry().timer(name, tags));
        }
        this.setLastTimeExchange();
    }

    private void setLastTimeExchange() {
        Gauge meter = this.getMeterRegistry().find("camel.exchanges.last.timestamp").gauge();
        if (meter == null) {
            meter = Gauge.builder((String)"camel.exchanges.last.timestamp", (Object)lastExchangeTimestampHolder, AtomicLong::get).description("Last exchange processed time in milliseconds since the Unix epoch").register(this.getMeterRegistry());
        }
        lastExchangeTimestampHolder.set(System.currentTimeMillis());
    }
}

