/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedLogMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.slf4j.Marker;

@ManagedResource(description="Managed Log")
public class ManagedLog
extends ManagedProcessor
implements ManagedLogMBean {
    public ManagedLog(CamelContext context, LogProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
    }

    public LogProcessor getProcessor() {
        return (LogProcessor)super.getProcessor();
    }

    public String getMessage() {
        if (this.getProcessor().getExpression() != null) {
            return this.getProcessor().getExpression().toString();
        }
        return this.getProcessor().getMessage();
    }

    public String getLoggingLevel() {
        LoggingLevel level = this.getProcessor().getLogger().getLevel();
        return level != null ? level.name() : null;
    }

    public String getLogName() {
        return this.getProcessor().getLogger().getLog().getName();
    }

    public String getMarker() {
        Marker marker = this.getProcessor().getLogger().getMarker();
        return marker != null ? marker.getName() : null;
    }
}

