/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedDoTryMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.TryProcessor;

@ManagedResource(description="Managed DoTry")
public class ManagedDoTry
extends ManagedProcessor
implements ManagedDoTryMBean {
    public ManagedDoTry(CamelContext context, TryProcessor processor, TryDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    public TryProcessor getProcessor() {
        return (TryProcessor)super.getProcessor();
    }

    public TryDefinition getDefinition() {
        return (TryDefinition)super.getDefinition();
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.doTryTabularType());
            List<CatchProcessor> catchProcessors = this.getCatchProcessors();
            List exceptions = this.getDefinition().getCatchClauses();
            for (int i = 0; i < catchProcessors.size(); ++i) {
                CatchDefinition when = (CatchDefinition)exceptions.get(i);
                CatchProcessor caught = catchProcessors.get(i);
                if (caught == null) continue;
                for (String fqn : caught.getCaughtExceptionClassNames()) {
                    CompositeType ct = CamelOpenMBeanTypes.doTryCompositeType();
                    String predicate = null;
                    String language = null;
                    if (when.getOnWhen() != null) {
                        predicate = when.getOnWhen().getExpression().getExpression();
                        language = when.getOnWhen().getExpression().getLanguage();
                    }
                    long matches = caught.getCaughtCount(fqn);
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "predicate", "language", "matches"}, new Object[]{fqn, predicate, language, matches});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private CatchProcessor asCatchProcessor(Navigate<Processor> nav) {
        while (nav.hasNext()) {
            for (Processor p : nav.next()) {
                if (p instanceof CatchProcessor) {
                    CatchProcessor catchProcessor = (CatchProcessor)p;
                    return catchProcessor;
                }
                if (!(p instanceof Navigate)) continue;
                Navigate child = (Navigate)p;
                return this.asCatchProcessor((Navigate<Processor>)child);
            }
        }
        return null;
    }

    private List<CatchProcessor> getCatchProcessors() {
        ArrayList<CatchProcessor> answer = new ArrayList<CatchProcessor>();
        if (this.getProcessor().getCatchClauses() != null && !this.getProcessor().getCatchClauses().isEmpty()) {
            for (Processor p : this.getProcessor().getCatchClauses()) {
                Channel c = (Channel)p;
                CatchProcessor caught = this.asCatchProcessor((Navigate<Processor>)c);
                answer.add(caught);
            }
        }
        return answer;
    }
}

