/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.SQLException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jdbc.BeanRowMapper;
import org.apache.camel.component.jdbc.JdbcHelper;
import org.apache.camel.support.RowMapper;

public class JdbcBeanMapper
implements RowMapper<Map<String, Object>, Object> {
    private final CamelContext camelContext;
    private final String outputClass;
    private final BeanRowMapper beanRowMapper;

    public JdbcBeanMapper(CamelContext camelContext, String outputClass, BeanRowMapper beanRowMapper) {
        this.camelContext = camelContext;
        this.outputClass = outputClass;
        this.beanRowMapper = beanRowMapper;
    }

    public Object map(Map<String, Object> row) {
        if (row != null && this.outputClass != null) {
            try {
                return JdbcHelper.newBeanInstance(this.camelContext, this.outputClass, this.beanRowMapper, row);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return row;
    }
}

