/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import io.debezium.embedded.Connect;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.support.DefaultConsumer;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumConsumer.class);
    private final DebeziumEndpoint endpoint;
    private final EmbeddedDebeziumConfiguration configuration;
    private ExecutorService executorService;
    private DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>> dbzEngine;

    public DebeziumConsumer(DebeziumEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executorService = this.endpoint.createExecutor((Object)this);
        this.dbzEngine = this.createDbzEngine();
        this.executorService.submit(() -> {
            try {
                this.dbzEngine.run();
            }
            catch (Throwable e) {
                LOG.error("Debezium engine has failed: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    protected void doStop() throws Exception {
        if (this.dbzEngine != null) {
            this.dbzEngine.close();
        }
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
        super.doStop();
    }

    private DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>> createDbzEngine() {
        return DebeziumEngine.create(Connect.class).using(this.configuration.createDebeziumConfiguration().asProperties()).notifying(this::onEventListener).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventListener(ChangeEvent<SourceRecord, SourceRecord> event) {
        Exchange exchange = this.endpoint.createDbzExchange(this, (SourceRecord)event.value());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
            this.releaseExchange(exchange, false);
        }
    }
}

