/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.spi.BacklogTracer;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="trace", displayName="Camel Tracing", description="Trace routed messages")
@Configurer(extended=true)
public class TraceDevConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="100", description="Maximum capacity of last number of messages to capture (capacity must be between 50 and 1000)")
    private int capacity = 100;
    public static final String ENABLED = "enabled";
    public static final String DUMP = "dump";
    private Queue<BacklogTracerEventMessage> queue;

    public TraceDevConsole() {
        super("camel", "trace", "Camel Tracing", "Trace routed messages");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected void doInit() throws Exception {
        if (this.capacity > 1000 || this.capacity < 50) {
            throw new IllegalArgumentException("Capacity must be between 50 and 1000");
        }
        this.queue = new LinkedBlockingQueue<BacklogTracerEventMessage>(this.capacity);
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        String enabled = (String)options.get(ENABLED);
        String dump = (String)options.get(DUMP);
        BacklogTracer tracer = (BacklogTracer)this.getCamelContext().getCamelContextExtension().getContextPlugin(BacklogTracer.class);
        if (tracer != null) {
            if (dump != null) {
                for (BacklogTracerEventMessage t : tracer.dumpAllTracedMessages()) {
                    this.addMessage(t);
                }
                for (BacklogTracerEventMessage t : this.queue) {
                    String json = t.toJSon(0);
                    sb.append(json).append("\n");
                }
            } else {
                if ("true".equals(enabled)) {
                    tracer.setEnabled(true);
                } else if ("false".equals(enabled)) {
                    tracer.setEnabled(false);
                }
                sb.append("Enabled: ").append(tracer.isEnabled()).append("\n");
                sb.append("Standby: ").append(tracer.isStandby()).append("\n");
                sb.append("Trace Counter: ").append(tracer.getTraceCounter()).append("\n");
                sb.append("Backlog Size: ").append(tracer.getBacklogSize()).append("\n");
                sb.append("Queue Size: ").append(tracer.getQueueSize()).append("\n");
                sb.append("Remove On Dump: ").append(tracer.isRemoveOnDump()).append("\n");
                if (tracer.getTraceFilter() != null) {
                    sb.append("Trace Filter: ").append(tracer.getTraceFilter()).append("\n");
                }
                if (tracer.getTracePattern() != null) {
                    sb.append("Trace Pattern: ").append(tracer.getTracePattern()).append("\n");
                }
                sb.append("Trace Rests: ").append(tracer.isTraceRests()).append("\n");
                sb.append("Trace Templates: ").append(tracer.isTraceTemplates()).append("\n");
                sb.append("Body Max Chars: ").append(tracer.getBodyMaxChars()).append("\n");
                sb.append("Body Include Files: ").append(tracer.isBodyIncludeFiles()).append("\n");
                sb.append("Body Include Streams: ").append(tracer.isBodyIncludeStreams()).append("\n");
                sb.append("Include Exchange Properties: ").append(tracer.isIncludeExchangeProperties()).append("\n");
                sb.append("Include Exchange Variables: ").append(tracer.isIncludeExchangeVariables()).append("\n");
                sb.append("Include Exception: ").append(tracer.isIncludeException()).append("\n");
            }
        }
        return sb.toString();
    }

    private void addMessage(BacklogTracerEventMessage message) {
        int drain = this.queue.size() - this.capacity + 1;
        if (drain > 0) {
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(message);
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        String enabled = (String)options.get(ENABLED);
        String dump = (String)options.get(DUMP);
        BacklogTracer tracer = (BacklogTracer)this.getCamelContext().getCamelContextExtension().getContextPlugin(BacklogTracer.class);
        if (tracer != null) {
            if (dump != null) {
                for (BacklogTracerEventMessage t : tracer.dumpAllTracedMessages()) {
                    this.addMessage(t);
                }
                JsonArray arr = new JsonArray();
                root.put((Object)ENABLED, (Object)tracer.isEnabled());
                root.put((Object)"traces", (Object)arr);
                for (BacklogTracerEventMessage t : this.queue) {
                    JsonObject jo = (JsonObject)t.asJSon();
                    arr.add((Object)jo);
                }
            } else {
                if ("true".equals(enabled)) {
                    tracer.setEnabled(true);
                } else if ("false".equals(enabled)) {
                    tracer.setEnabled(false);
                }
                root.put((Object)ENABLED, (Object)tracer.isEnabled());
                root.put((Object)"standby", (Object)tracer.isStandby());
                root.put((Object)"counter", (Object)tracer.getTraceCounter());
                root.put((Object)"backlogSize", (Object)tracer.getBacklogSize());
                root.put((Object)"queueSize", (Object)tracer.getQueueSize());
                root.put((Object)"removeOnDump", (Object)tracer.isRemoveOnDump());
                if (tracer.getTraceFilter() != null) {
                    root.put((Object)"traceFilter", (Object)tracer.getTraceFilter());
                }
                if (tracer.getTracePattern() != null) {
                    root.put((Object)"tracePattern", (Object)tracer.getTracePattern());
                }
                root.put((Object)"traceRests", (Object)tracer.isTraceRests());
                root.put((Object)"traceTemplates", (Object)tracer.isTraceTemplates());
                root.put((Object)"bodyMaxChars", (Object)tracer.getBodyMaxChars());
                root.put((Object)"bodyIncludeFiles", (Object)tracer.isBodyIncludeFiles());
                root.put((Object)"bodyIncludeStreams", (Object)tracer.isBodyIncludeStreams());
                root.put((Object)"includeExchangeProperties", (Object)tracer.isIncludeExchangeProperties());
                root.put((Object)"includeExchangeVariables", (Object)tracer.isIncludeExchangeVariables());
                root.put((Object)"includeException", (Object)tracer.isIncludeException());
            }
        }
        return root;
    }
}

