/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.dhis2.Dhis2Component;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

public interface Dhis2ComponentBuilderFactory {
    public static Dhis2ComponentBuilder dhis2() {
        return new Dhis2ComponentBuilderImpl();
    }

    public static class Dhis2ComponentBuilderImpl
    extends AbstractComponentBuilder<Dhis2Component>
    implements Dhis2ComponentBuilder {
        @Override
        protected Dhis2Component buildConcreteComponent() {
            return new Dhis2Component();
        }

        private Dhis2Configuration getOrCreateConfiguration(Dhis2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Dhis2Configuration());
            }
            return (Dhis2Configuration)component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "baseApiUrl": {
                    this.getOrCreateConfiguration((Dhis2Component)component).setBaseApiUrl((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Dhis2Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((Dhis2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((Dhis2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "client": {
                    this.getOrCreateConfiguration((Dhis2Component)component).setClient((Dhis2Client)value);
                    return true;
                }
                case "configuration": {
                    ((Dhis2Component)component).setConfiguration((Dhis2Configuration)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((Dhis2Component)component).setPassword((String)value);
                    return true;
                }
                case "personalAccessToken": {
                    this.getOrCreateConfiguration((Dhis2Component)component).setPersonalAccessToken((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((Dhis2Component)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Dhis2ComponentBuilder
    extends ComponentBuilder<Dhis2Component> {
        default public Dhis2ComponentBuilder baseApiUrl(String baseApiUrl) {
            this.doSetProperty("baseApiUrl", baseApiUrl);
            return this;
        }

        default public Dhis2ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Dhis2ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Dhis2ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Dhis2ComponentBuilder client(Dhis2Client client) {
            this.doSetProperty("client", client);
            return this;
        }

        default public Dhis2ComponentBuilder configuration(Dhis2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Dhis2ComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public Dhis2ComponentBuilder personalAccessToken(String personalAccessToken) {
            this.doSetProperty("personalAccessToken", personalAccessToken);
            return this;
        }

        default public Dhis2ComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

