/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.lambda.Lambda2Component;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.lambda.LambdaClient;

public interface Aws2LambdaComponentBuilderFactory {
    public static Aws2LambdaComponentBuilder aws2Lambda() {
        return new Aws2LambdaComponentBuilderImpl();
    }

    public static class Aws2LambdaComponentBuilderImpl
    extends AbstractComponentBuilder<Lambda2Component>
    implements Aws2LambdaComponentBuilder {
        @Override
        protected Lambda2Component buildConcreteComponent() {
            return new Lambda2Component();
        }

        private Lambda2Configuration getOrCreateConfiguration(Lambda2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Lambda2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Lambda2Component)component).setConfiguration((Lambda2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Lambda2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setOperation((Lambda2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Lambda2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "awsLambdaClient": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setAwsLambdaClient((LambdaClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((Lambda2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((Lambda2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2LambdaComponentBuilder
    extends ComponentBuilder<Lambda2Component> {
        default public Aws2LambdaComponentBuilder configuration(Lambda2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2LambdaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2LambdaComponentBuilder operation(Lambda2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2LambdaComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2LambdaComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2LambdaComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2LambdaComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2LambdaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2LambdaComponentBuilder awsLambdaClient(LambdaClient awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public Aws2LambdaComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2LambdaComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2LambdaComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2LambdaComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2LambdaComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2LambdaComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2LambdaComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2LambdaComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2LambdaComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2LambdaComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

