/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.trackers.concurrent.ThreadEvent;
import org.nuxeo.runtime.trackers.files.FileEvent;
import org.nuxeo.runtime.trackers.files.FileEventHandler;
import org.nuxeo.runtime.trackers.files.FileEventListener;

@Features(value={RuntimeFeature.class})
public class FileEventsTrackingFeature
extends SimpleFeature {
    protected final Set<File> tracked = new HashSet<File>();
    protected Tracker tracker = new Tracker();
    protected FileEventListener listener = new FileEventListener((FileEventHandler)this.tracker);
    protected Path tempPath;
    protected Set<File> created = new HashSet<File>();

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        File temp = Environment.getDefault().getTemp();
        this.tempPath = temp.toPath();
        this.tracked.clear();
        this.created.clear();
        this.listener.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        this.listener.uninstall();
        try {
            Assert.assertThat(this.tracked, (Matcher)CoreMatchers.is(this.created));
            for (File each : this.created) {
                Assert.assertThat((Object)each.exists(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
        finally {
            this.tracked.clear();
            this.created.clear();
        }
    }

    public ThreadEvent onThreadEnter(boolean isLongRunning) {
        return ThreadEvent.onEnter((Object)this, (boolean)isLongRunning);
    }

    public FileEvent onFile(File aFile, Object aMarker) {
        return FileEvent.onFile((Object)this, (File)this.resolveAndCreate(aFile), (Object)aMarker);
    }

    public File resolveAndCreate(File aFile) {
        File temp = Environment.getDefault().getTemp();
        File actual = temp.toPath().resolve(aFile.toPath()).toFile();
        try {
            actual.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp file " + actual);
        }
        this.created.add(actual);
        return actual;
    }

    protected class Tracker
    implements FileEventHandler {
        protected Tracker() {
        }

        public void onFile(File file, Object marker) {
            FileEventsTrackingFeature.this.tracked.add(file);
        }
    }
}

