/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class ConditionalIgnoreRule
implements MethodRule {
    @Inject
    private RunNotifier runNotifier;
    @Inject
    private FeaturesRunner runner;

    public Statement apply(Statement base, FrameworkMethod method, Object fixtureTarget) {
        Class<?> fixtureType = fixtureTarget.getClass();
        Method fixtureMethod = method.getMethod();
        Description description = Description.createTestDescription(fixtureType, (String)fixtureMethod.getName(), (Annotation[])fixtureMethod.getAnnotations());
        return this.shouldIgnore(base, description, this.runner.getConfig(method, Ignore.class), fixtureType, fixtureMethod, fixtureTarget);
    }

    protected Statement shouldIgnore(Statement base, Description description, Ignore ignore, Class<?> type) {
        return this.shouldIgnore(base, description, ignore, type, null, null);
    }

    protected Statement shouldIgnore(Statement base, final Description description, Ignore ignore, Class<?> type, Method method, Object target) {
        Class<? extends Condition> conditionType = ignore.condition();
        if (conditionType == null) {
            return base;
        }
        if (!this.newCondition(type, method, target, conditionType).shouldIgnore()) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                ConditionalIgnoreRule.this.runNotifier.fireTestIgnored(description);
            }
        };
    }

    protected Condition newCondition(Class<?> type, Method method, Object target, Class<? extends Condition> conditionType) throws Error {
        Condition condition;
        try {
            condition = conditionType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException cause) {
            throw new Error("Cannot instantiate condition of type " + conditionType, cause);
        }
        this.injectCondition(type, method, target, condition);
        return condition;
    }

    protected void injectCondition(Class<?> type, Method method, Object target, Condition condition) throws SecurityException, Error {
        Error errors = new Error("Cannot inject condition parameters in " + condition.getClass());
        for (Field eachField : condition.getClass().getDeclaredFields()) {
            if (!eachField.isAnnotationPresent(Inject.class)) continue;
            Object eachValue = null;
            if (eachField.isAnnotationPresent(Named.class)) {
                String name = eachField.getAnnotation(Named.class).value();
                if ("type".equals(name)) {
                    eachValue = type;
                } else if ("target".equals(name)) {
                    eachValue = target;
                } else if ("method".equals(name)) {
                    eachValue = method;
                }
            } else {
                Class<?> eachType = eachField.getType();
                if (eachType.equals(Class.class)) {
                    eachValue = type;
                } else if (eachType.equals(Object.class)) {
                    eachValue = target;
                } else if (eachType.equals(Method.class)) {
                    eachValue = method;
                }
            }
            if (eachValue == null) continue;
            eachField.setAccessible(true);
            try {
                eachField.set(condition, eachValue);
            }
            catch (IllegalAccessException | IllegalArgumentException cause) {
                errors.addSuppressed(new Error("Cannot inject " + eachField.getName(), cause));
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
        this.runner.getInjector().injectMembers((Object)condition);
    }

    public static final class IgnoreWindows
    implements Condition {
        @Override
        public boolean shouldIgnore() {
            return SystemUtils.IS_OS_WINDOWS;
        }
    }

    public static final class IgnoreLongRunning
    implements Condition {
        @Override
        public boolean shouldIgnore() {
            return true;
        }
    }

    public static final class IgnoreIsolated
    implements Condition {
        boolean isIsolated = "org.nuxeo.runtime.testsuite.IsolatedClassloader".equals(this.getClass().getClassLoader().getClass().getName());

        @Override
        public boolean shouldIgnore() {
            return this.isIsolated;
        }
    }

    public static final class NXP10926H2Upgrade
    implements Condition {
        @Override
        public boolean shouldIgnore() {
            return false;
        }
    }

    public static interface Condition {
        public boolean shouldIgnore();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Ignore {
        public Class<? extends Condition> condition();

        public String cause() default "";
    }

    public static class Feature
    extends SimpleFeature {
        protected static final ConditionalIgnoreRule rule = new ConditionalIgnoreRule();

        @Rule
        public MethodRule methodRule() {
            return rule;
        }
    }
}

