/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.nuxeo.common.Environment;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.SystemBundleFile;
import org.nuxeo.osgi.application.StandaloneBundleLoader;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.nuxeo.runtime.test.InlineRef;
import org.nuxeo.runtime.test.RootRuntimeBundle;
import org.nuxeo.runtime.test.TargetResourceLocator;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.protocols.inline.InlineURLFactory;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.MDCFeature;
import org.nuxeo.runtime.test.runner.RandomBug;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.TargetExtensions;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;

@RunWith(value=FeaturesRunner.class)
@Features(value={MDCFeature.class, ConditionalIgnoreRule.Feature.class, RandomBug.Feature.class})
@Ignore
public class NXRuntimeTestCase
implements RuntimeHarness {
    protected Mockery jmcontext = new JUnit4Mockery();
    private static final Log log;
    protected OSGiRuntimeService runtime;
    protected URL[] urls;
    protected File workingDir;
    protected StandaloneBundleLoader bundleLoader;
    private Set<URI> readUris;
    protected Map<String, BundleFile> bundles;
    protected boolean restart = false;
    protected OSGiAdapter osgi;
    protected Bundle runtimeBundle;
    protected final List<WorkingDirectoryConfigurator> wdConfigs = new ArrayList<WorkingDirectoryConfigurator>();
    protected final TargetResourceLocator targetResourceLocator;

    @Override
    public boolean isRestart() {
        return this.restart;
    }

    public NXRuntimeTestCase() {
        this.targetResourceLocator = new TargetResourceLocator(this.getClass());
    }

    public NXRuntimeTestCase(String name) {
        this();
    }

    public NXRuntimeTestCase(Class<?> clazz) {
        this.targetResourceLocator = new TargetResourceLocator(clazz);
    }

    @Override
    public void addWorkingDirectoryConfigurator(WorkingDirectoryConfigurator config) {
        this.wdConfigs.add(config);
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void restart() throws Exception {
        this.restart = true;
        try {
            this.tearDown();
            this.setUp();
        }
        finally {
            this.restart = false;
        }
    }

    @Override
    public void start() throws Exception {
        this.setUp();
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.nuxeo.runtime.testing", "true");
        this.wipeRuntime();
        this.initUrls();
        if (this.urls == null) {
            throw new UnsupportedOperationException("no bundles available");
        }
        this.initOsgiRuntime();
    }

    @Override
    public void fireFrameworkStarted() throws Exception {
        boolean txStarted = !TransactionHelper.isTransactionActiveOrMarkedRollback() && TransactionHelper.startTransaction();
        boolean txFinished = false;
        try {
            this.osgi.fireFrameworkEvent(new FrameworkEvent(1, this.runtimeBundle, null));
            txFinished = true;
        }
        finally {
            if (!txFinished) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            if (txStarted) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.wipeRuntime();
        if (this.workingDir != null && !this.restart) {
            if (this.workingDir.exists() && !FileUtils.deleteQuietly((File)this.workingDir)) {
                log.warn((Object)("Cannot delete " + this.workingDir));
            }
            this.workingDir = null;
        }
        this.readUris = null;
        this.bundles = null;
    }

    @Override
    public void stop() throws Exception {
        this.tearDown();
    }

    @Override
    public boolean isStarted() {
        return this.runtime != null;
    }

    protected void initOsgiRuntime() throws Exception {
        try {
            if (!this.restart) {
                Environment.setDefault(null);
                if (System.getProperties().remove("nuxeo.home") != null) {
                    log.warn((Object)"Removed System property nuxeo.home.");
                }
                this.workingDir = File.createTempFile("nxruntime-" + Thread.currentThread().getName() + "-", null, new File("target"));
                this.workingDir.delete();
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not init working directory", (Throwable)e);
            throw e;
        }
        this.osgi = new OSGiAdapter(this.workingDir);
        SystemBundleFile bf = new SystemBundleFile(this.workingDir);
        this.bundleLoader = new StandaloneBundleLoader(this.osgi, NXRuntimeTestCase.class.getClassLoader());
        SystemBundle systemBundle = new SystemBundle(this.osgi, (BundleFile)bf, this.bundleLoader.getSharedClassLoader().getLoader());
        this.osgi.setSystemBundle(systemBundle);
        Thread.currentThread().setContextClassLoader(this.bundleLoader.getSharedClassLoader().getLoader());
        for (WorkingDirectoryConfigurator cfg : this.wdConfigs) {
            cfg.configure(this, this.workingDir);
        }
        this.bundleLoader.setScanForNestedJARs(false);
        this.bundleLoader.setExtractNestedJARs(false);
        BundleFile bundleFile = this.lookupBundle("org.nuxeo.runtime");
        this.runtimeBundle = new RootRuntimeBundle(this.osgi, bundleFile, this.bundleLoader.getClass().getClassLoader(), true);
        this.runtimeBundle.start();
        this.runtime = this.handleNewRuntime((OSGiRuntimeService)Framework.getRuntime());
        Assert.assertNotNull((Object)this.runtime);
    }

    protected OSGiRuntimeService handleNewRuntime(OSGiRuntimeService aRuntime) {
        return aRuntime;
    }

    public static URL[] introspectClasspath(ClassLoader loader) {
        return (URL[])new FastClasspathScanner(new String[0]).getUniqueClasspathElements().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException cause) {
                throw new Error("Could not get URL from " + file, cause);
            }
        }).toArray(URL[]::new);
    }

    protected void initUrls() throws Exception {
        ClassLoader classLoader = NXRuntimeTestCase.class.getClassLoader();
        this.urls = NXRuntimeTestCase.introspectClasspath(classLoader);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("URLs on the classpath: ");
            for (URL url : this.urls) {
                sb.append(url.toString());
                sb.append('\n');
            }
            log.debug((Object)sb.toString());
        }
        this.readUris = new HashSet<URI>();
        this.bundles = new HashMap<String, BundleFile>();
    }

    protected void wipeRuntime() throws Exception {
        this.runtime = null;
        if (Framework.getRuntime() != null) {
            Framework.shutdown();
        }
    }

    public static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String callerName = Thread.currentThread().getStackTrace()[2].getClassName();
        String relativePath = callerName.replace('.', '/').concat(".class");
        String fullPath = loader.getResource(relativePath).getPath();
        String basePath = fullPath.substring(0, fullPath.indexOf(relativePath));
        try {
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (!resource.getPath().startsWith(basePath)) continue;
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return loader.getResource(name);
    }

    protected void deployContrib(URL url) {
        Assert.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Deploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().deploy(url);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to deploy contrib " + url.toString()));
        }
    }

    @Override
    public void deployContrib(String name, String contrib) throws Exception {
        RuntimeContext context = this.runtime.getContext(name);
        if (context == null) {
            context = this.runtime.getContext();
            BundleFile file = this.lookupBundle(name);
            URL location = file.getEntry(contrib);
            if (location == null) {
                throw new AssertionError((Object)("Cannot locate " + contrib + " in " + name));
            }
            context.deploy(location);
            return;
        }
        context.deploy(contrib);
    }

    @Override
    public RuntimeContext deployTestContrib(String bundle, String contrib) throws Exception {
        URL url = this.targetResourceLocator.getTargetTestResource(contrib);
        return this.deployTestContrib(bundle, url);
    }

    @Override
    public RuntimeContext deployTestContrib(String bundle, URL contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b == null) {
            b = this.osgi.getSystemBundle();
        }
        OSGiRuntimeContext ctx = new OSGiRuntimeContext((RuntimeService)this.runtime, (Bundle)b);
        ctx.deploy(contrib);
        return ctx;
    }

    @Override
    public RuntimeContext deployPartial(String name, Set<TargetExtensions> targetExtensions) throws Exception {
        BundleImpl bundle = new BundleImpl(this.osgi, this.lookupBundle(name), null);
        OSGiRuntimeContext ctx = new OSGiRuntimeContext((RuntimeService)this.runtime, (Bundle)bundle);
        this.listBundleComponents((Bundle)bundle).map(URLStreamRef::new).forEach(arg_0 -> this.lambda$deployPartial$2((RuntimeContext)ctx, targetExtensions, name, arg_0));
        return ctx;
    }

    protected void deployPartialComponent(RuntimeContext ctx, Set<TargetExtensions> extensionPoints, StreamRef component) throws IOException {
        RegistrationInfoImpl ri = ((DefaultRuntimeContext)ctx).createRegistrationInfo(component);
        String name = ri.getName().getName() + "-partial";
        Set targets = extensionPoints.stream().map(TargetExtensions::getTargetExtensions).flatMap(Collection::stream).collect(Collectors.toSet());
        String ext = Arrays.stream(ri.getExtensions()).filter(e -> targets.contains(TargetExtensions.newTargetExtension(e.getTargetComponent().getName(), e.getExtensionPoint()))).map(Extension::toXML).collect(Collectors.joining());
        InlineURLFactory.install();
        ctx.deploy((StreamRef)new InlineRef(name, String.format("<component name=\"%s\">%s</component>", name, ext)));
    }

    protected Stream<URL> listBundleComponents(Bundle bundle) {
        String list = OSGiRuntimeService.getComponentsList((Bundle)bundle);
        String name = bundle.getSymbolicName();
        log.debug((Object)("PartialBundle: " + name + " components: " + list));
        if (list == null) {
            return null;
        }
        return Arrays.stream(list.split("[, \t\n\r\f]")).map(s -> bundle.getEntry(s)).filter(Objects::nonNull);
    }

    @Override
    public void undeployContrib(String name, String contrib) throws Exception {
        RuntimeContext context = this.runtime.getContext(name);
        if (context == null) {
            context = this.runtime.getContext();
        }
        context.undeploy(contrib);
    }

    protected static boolean isVersionSuffix(String s) {
        if (s.length() == 0) {
            return true;
        }
        return s.matches("-(\\d+\\.?)+(-SNAPSHOT)?(\\.\\w+)?");
    }

    protected URL lookupBundleUrl(String bundle) {
        for (URL url : this.urls) {
            String[] pathElts = url.getPath().split("/");
            for (int i = 0; i < pathElts.length; ++i) {
                if (!pathElts[i].startsWith(bundle) || !NXRuntimeTestCase.isVersionSuffix(pathElts[i].substring(bundle.length()))) continue;
                boolean isTestVersion = false;
                for (int j = i + 1; j < pathElts.length; ++j) {
                    if (!pathElts[j].startsWith("test")) continue;
                    isTestVersion = true;
                    break;
                }
                if (isTestVersion) continue;
                log.info((Object)("Resolved " + bundle + " as " + url.toString()));
                return url;
            }
        }
        throw new RuntimeException("Could not resolve bundle " + bundle);
    }

    @Override
    public void deployBundle(String name) throws Exception {
        BundleImpl bundle = this.bundleLoader.getOSGi().getRegistry().getBundle(name);
        if (bundle == null) {
            BundleFile bundleFile = this.lookupBundle(name);
            this.bundleLoader.loadBundle(bundleFile);
            this.bundleLoader.installBundle(bundleFile);
            bundle = this.bundleLoader.getOSGi().getRegistry().getBundle(name);
        }
        if (this.runtime.getContext((Bundle)bundle) == null) {
            this.runtime.createContext((Bundle)bundle);
        }
    }

    protected String readSymbolicName(BundleFile bf) {
        Manifest manifest = bf.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes attrs = manifest.getMainAttributes();
        String name = attrs.getValue("Bundle-SymbolicName");
        if (name == null) {
            return null;
        }
        String[] sp = name.split(";", 2);
        return sp[0];
    }

    public BundleFile lookupBundle(String bundleName) throws Exception {
        Object bundleFile = this.bundles.get(bundleName);
        if (bundleFile != null) {
            return bundleFile;
        }
        for (URL url : this.urls) {
            URI uri = url.toURI();
            if (this.readUris.contains(uri)) continue;
            File file = new File(uri);
            this.readUris.add(uri);
            try {
                bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            }
            catch (IOException e) {
                continue;
            }
            String symbolicName = this.readSymbolicName((BundleFile)bundleFile);
            if (symbolicName != null) {
                log.info((Object)String.format("Bundle '%s' has URL %s", symbolicName, url));
                this.bundles.put(symbolicName, (BundleFile)bundleFile);
            }
            if (!bundleName.equals(symbolicName)) continue;
            return bundleFile;
        }
        throw new RuntimeServiceException(String.format("No bundle with symbolic name '%s';", bundleName));
    }

    @Override
    public void deployFolder(File folder, ClassLoader loader) throws Exception {
        DirectoryBundleFile bf = new DirectoryBundleFile(folder);
        BundleImpl bundle = new BundleImpl(this.osgi, (BundleFile)bf, loader);
        this.osgi.install(bundle);
    }

    @Override
    public Properties getProperties() {
        return this.runtime.getProperties();
    }

    @Override
    public RuntimeContext getContext() {
        return this.runtime.getContext();
    }

    @Override
    public OSGiAdapter getOSGiAdapter() {
        return this.osgi;
    }

    @Override
    public List<String> getClassLoaderFiles() throws URISyntaxException {
        ArrayList<String> files = new ArrayList<String>(this.urls.length);
        for (URL url : this.urls) {
            files.add(url.toURI().getPath());
        }
        return files;
    }

    private /* synthetic */ void lambda$deployPartial$2(RuntimeContext ctx, Set targetExtensions, String name, URLStreamRef component) {
        try {
            this.deployPartialComponent(ctx, targetExtensions, (StreamRef)component);
        }
        catch (IOException e) {
            log.error((Object)("PartialBundle: " + name + " failed to load: " + component), (Throwable)e);
        }
    }

    static {
        System.setProperty("org.nuxeo.runtime.redirectJUL", "false");
        log = LogFactory.getLog(NXRuntimeTestCase.class);
    }
}

