/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.web.Configuration;
import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class WebPage {
    public static int DEFAULT_TIMEOUT = 5;
    public static int BIG_TIMEOUT = 15;
    private static final Map<Class<?>, WebPage> pages = new HashMap();
    @Inject
    protected Configuration config;
    @Inject
    protected WebDriver driver;
    @Inject
    protected FeaturesRunner runner;

    public WebPage ensureLoaded() {
        return this;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public FeaturesRunner getRunner() {
        return this.runner;
    }

    public void home() {
        this.driver.get(this.config.home);
    }

    public void to(String path) {
        if (path.contains("://")) {
            this.driver.get(path);
        } else {
            try {
                URL url = new URL(new URL(this.config.home), path);
                this.driver.navigate().to(url);
            }
            catch (MalformedURLException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    public boolean hasElement(By by) {
        try {
            this.driver.findElement(by);
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public boolean hasElement(By by, int timeoutInSeconds) {
        try {
            this.findElement(by, timeoutInSeconds);
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by, int timeOutInSeconds) {
        return this.waitUntilElementFound(by, timeOutInSeconds);
    }

    public WebElement waitUntilElementFound(final By by, int timeOutInSeconds) {
        try {
            return this.findElement(by);
        }
        catch (NotFoundException e) {
            return new WebDriverWait(this.driver, timeOutInSeconds).until(new ExpectedCondition<WebElement>(){

                public WebElement apply(WebDriver arg0) {
                    return WebPage.this.driver.findElement(by);
                }
            });
        }
    }

    public void waitUntilElementNotFound(final By by, int timeOutInSeconds) {
        try {
            this.findElement(by);
            new WebDriverWait(this.driver, timeOutInSeconds).until(new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver arg0) {
                    try {
                        WebPage.this.driver.findElement(by);
                        return Boolean.FALSE;
                    }
                    catch (NotFoundException e) {
                        return Boolean.TRUE;
                    }
                }
            });
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends WebPage> T getPage(Class<T> type) {
        WebPage page = pages.get(type);
        if (page == null) {
            Map<Class<?>, WebPage> map = pages;
            synchronized (map) {
                page = pages.get(type);
                if (page != null) {
                    return (T)page;
                }
                page = (WebPage)PageFactory.initElements((WebDriver)this.driver, type);
                this.runner.getInjector().injectMembers((Object)page);
                pages.put(type, page);
            }
        }
        return (T)page.ensureLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushPageCache() {
        Map<Class<?>, WebPage> map = pages;
        synchronized (map) {
            pages.clear();
        }
    }
}

