/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.remoting.ServerDescriptor;

public class RemoteClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog(RemoteClassLoader.class);
    private final ComponentName component;
    private final ServerDescriptor sd;
    private final Map<String, Class> loadedClasses = new Hashtable<String, Class>();
    private final Map<String, URI> loadedResources = new Hashtable<String, URI>();

    public RemoteClassLoader(ServerDescriptor sd, ComponentName component, ClassLoader parent) {
        super(parent != null ? parent : Thread.currentThread().getContextClassLoader());
        this.component = component;
        this.sd = sd;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> klass = this.loadedClasses.get(name);
        if (klass != null) {
            return klass;
        }
        log.info((Object)("Loading class " + name + " from remote"));
        try {
            byte[] bytes = this.sd.getServer().getClass(this.component, name);
            if (bytes != null) {
                klass = this.defineClass(name, bytes, 0, bytes.length, null);
                this.loadedClasses.put(name, klass);
                return klass;
            }
        }
        catch (Exception e) {
            log.error((Object)"findClass failed", (Throwable)e);
            throw new ClassNotFoundException("Failed to find remote class", e);
        }
        return klass;
    }

    @Override
    protected URL findResource(String name) {
        URL resource;
        try {
            resource = this.loadedResources.get(name).toURL();
        }
        catch (MalformedURLException e) {
            resource = null;
        }
        if (resource != null) {
            return resource;
        }
        log.info((Object)("Loading resource " + name + " from remote"));
        try {
            File file;
            byte[] bytes = this.sd.getServer().getClass(this.component, name);
            if (bytes != null && (resource = (file = RemoteClassLoader.createTempFile(name)).toURI().toURL()) != null) {
                this.loadedResources.put(name, resource.toURI());
                return resource;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to create temp file for storing remote resource", (Throwable)e);
        }
        return resource;
    }

    protected static File createTempFile(String name) throws IOException {
        File file = File.createTempFile("nxruntime-remote-" + name, ".tmp");
        file.deleteOnExit();
        return file;
    }
}

