/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.detection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.detection.DetectionHandler;
import org.nuxeo.runtime.detection.Peer;

public class MulticastDetector<T> {
    private static final Log log = LogFactory.getLog(MulticastDetector.class);
    protected final InetAddress groupAddr;
    protected final int groupPort;
    protected final String identity;
    protected final Map<String, Peer<T>> peers;
    protected MulticastSocket socket;
    protected long heartBeatTimeout = 5000L;
    private DetectionHandler handler;
    private HeartBeatDetection heartBeatDetection;
    private Timer heartBeatTimer;
    private Timer processingTimer;

    public MulticastDetector(String identity, InetAddress groupAddr, int groupPort) throws IOException {
        this.identity = identity;
        this.groupAddr = groupAddr;
        this.groupPort = groupPort;
        this.socket = new MulticastSocket(groupPort);
        this.peers = new HashMap<String, Peer<T>>();
    }

    public MulticastDetector(String identity) throws IOException {
        this(identity, "224.1.9.2", 4444);
    }

    public MulticastDetector(String identity, String groupAddr, int groupPort) throws IOException {
        this(identity, InetAddress.getByName(groupAddr), groupPort);
    }

    public void setDetectionHandler(DetectionHandler handler) {
        this.handler = handler;
    }

    public DetectionHandler getDetectionHandler() {
        return this.handler;
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public void setHeartBeatTimeout(long ms) {
        this.heartBeatTimeout = ms;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public synchronized void start() {
        if (this.heartBeatDetection != null) {
            return;
        }
        try {
            this.socket.setSoTimeout((int)this.heartBeatTimeout);
            this.heartBeatDetection = new HeartBeatDetection();
            this.heartBeatDetection.start();
            this.processingTimer = new Timer("Nuxeo.Detection.Cleanup");
            this.processingTimer.schedule((TimerTask)new CleanupTask(), this.heartBeatTimeout, this.heartBeatTimeout);
            this.socket.joinGroup(this.groupAddr);
            this.heartBeatTimer = new Timer("Nuxeo.Detection.HeartBeat");
            this.heartBeatTimer.schedule((TimerTask)new HeartBeatTask(), 0L, this.heartBeatTimeout);
        }
        catch (Throwable t) {
            this.stop();
        }
    }

    public synchronized void stop() {
        if (this.heartBeatDetection == null) {
            return;
        }
        this.heartBeatTimer.cancel();
        this.heartBeatTimer = null;
        this.heartBeatDetection.cancel();
        this.heartBeatDetection = null;
        this.processingTimer.cancel();
        this.processingTimer = null;
    }

    public String getIdentity() {
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer<T>[] getPeers() {
        Map<String, Peer<T>> map = this.peers;
        synchronized (map) {
            return this.peers.values().toArray(new Peer[this.peers.size()]);
        }
    }

    private DatagramPacket createHeartBeat() {
        byte[] bytes = this.identity.getBytes();
        return new DatagramPacket(bytes, bytes.length, this.groupAddr, this.groupPort);
    }

    private String readHeartBeat(DatagramPacket p) {
        return new String(p.getData(), p.getOffset(), p.getLength());
    }

    protected void notifyPeerOnline(Peer<T> peer) {
        if (this.handler != null) {
            this.processingTimer.schedule((TimerTask)new NotifyTask(peer, true), 0L);
        }
    }

    protected void notifyPeerOffline(Peer<T> peer) {
        if (this.handler != null) {
            this.handler.peerOffline(peer);
        }
    }

    class NotifyTask
    extends TimerTask {
        private final boolean online;
        private final Peer peer;

        NotifyTask(Peer<T> peer, boolean online) {
            this.peer = peer;
            this.online = online;
        }

        @Override
        public void run() {
            if (MulticastDetector.this.handler == null) {
                return;
            }
            if (this.online) {
                MulticastDetector.this.handler.peerOnline(this.peer);
            } else {
                MulticastDetector.this.handler.peerOffline(this.peer);
            }
        }
    }

    class CleanupTask
    extends TimerTask {
        CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Peer<T>[] arPeers;
            long tm = System.currentTimeMillis();
            for (Peer peer : arPeers = MulticastDetector.this.getPeers()) {
                if (tm - peer.lastHeartBeat <= MulticastDetector.this.heartBeatTimeout * 2L) continue;
                Map map = MulticastDetector.this.peers;
                synchronized (map) {
                    MulticastDetector.this.peers.remove(peer.identity);
                }
                System.out.println("Peer Offline: " + peer);
                MulticastDetector.this.notifyPeerOffline(peer);
                peer.data = null;
            }
        }
    }

    class HeartBeatTask
    extends TimerTask {
        HeartBeatTask() {
        }

        @Override
        public void run() {
            try {
                MulticastDetector.this.socket.send(MulticastDetector.this.createHeartBeat());
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    class HeartBeatDetection
    extends Thread {
        private boolean running;
        private final Object runLock;

        HeartBeatDetection() {
            super("Nuxeo.HeartBeatDetection");
            this.running = false;
            this.runLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.runLock;
            synchronized (object) {
                this.running = false;
            }
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void start() {
            Object object = this.runLock;
            synchronized (object) {
                this.running = true;
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                try {
                    while (true) {
                        Peer peer;
                        Object object = this.runLock;
                        synchronized (object) {
                            if (!this.running) {
                                break block9;
                            }
                        }
                        byte[] bytes = new byte[4000];
                        DatagramPacket p = new DatagramPacket(bytes, bytes.length);
                        MulticastDetector.this.socket.receive(p);
                        String identity = MulticastDetector.this.readHeartBeat(p);
                        if (MulticastDetector.this.identity.equals(identity)) continue;
                        Map map = MulticastDetector.this.peers;
                        synchronized (map) {
                            peer = MulticastDetector.this.peers.get(identity);
                            if (peer == null) {
                                peer = new Peer(p.getAddress(), p.getPort(), identity);
                                assert (peer.addr.equals(p.getAddress()));
                                assert (peer.port == p.getPort());
                                MulticastDetector.this.peers.put(identity, peer);
                            } else {
                                peer.lastHeartBeat = System.currentTimeMillis();
                                peer = null;
                            }
                        }
                        if (peer == null) continue;
                        System.out.println("Peer online: " + peer);
                        MulticastDetector.this.notifyPeerOnline(peer);
                    }
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (Throwable e) {
                    log.error((Object)e, e);
                    continue;
                }
                break;
            }
        }
    }
}

