/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.util.ArrayList;
import java.util.List;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.config.ConfigurationException;
import org.nuxeo.runtime.config.ServerConfiguration;
import org.nuxeo.runtime.remoting.UnsupportedServerVersionException;

public abstract class ConfigurationFactory {
    private static final List<ConfigurationFactory> registry = new ArrayList<ConfigurationFactory>();

    public static void registerFactory(ConfigurationFactory handler) {
        registry.add(handler);
    }

    public static ConfigurationFactory getFactory(Version version) throws UnsupportedServerVersionException {
        if (version == null) {
            version = Version.MIN;
        }
        int len = registry.size();
        for (int i = 0; i < len; ++i) {
            ConfigurationFactory cf = registry.get(i);
            if (!cf.accept(version)) continue;
            return cf;
        }
        throw new UnsupportedServerVersionException(version);
    }

    public boolean accept(Version v) {
        return v.isEqualTo(this.getVersion());
    }

    public abstract Version getVersion();

    public abstract ServerConfiguration createConfiguration(InvokerLocator var1, Version var2) throws ConfigurationException;
}

