/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.aws;

import com.amazonaws.SdkClientException;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.AWSConfigurationService;

public class NuxeoAWSRegionProvider
extends AwsRegionProvider {
    protected static final AwsRegionProvider INSTANCE = new NuxeoAWSRegionProvider();
    protected static final AwsRegionProvider DEFAULT = new DefaultAwsRegionProviderChain();
    protected static final String DEFAULT_REGION = "us-east-1";

    public static AwsRegionProvider getInstance() {
        return INSTANCE;
    }

    public String getRegion() {
        String region;
        AWSConfigurationService service = (AWSConfigurationService)Framework.getService(AWSConfigurationService.class);
        if (service != null && (region = service.getAWSRegion()) != null) {
            return region;
        }
        try {
            region = DEFAULT.getRegion();
        }
        catch (SdkClientException e) {
            region = null;
        }
        return StringUtils.defaultString((String)region, (String)DEFAULT_REGION);
    }
}

