/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.dev.webdav.jaxrs.methods.COPY;
import net.java.dev.webdav.jaxrs.methods.LOCK;
import net.java.dev.webdav.jaxrs.methods.MKCOL;
import net.java.dev.webdav.jaxrs.methods.MOVE;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.methods.PROPPATCH;
import net.java.dev.webdav.jaxrs.methods.UNLOCK;
import net.java.dev.webdav.jaxrs.xml.elements.ActiveLock;
import net.java.dev.webdav.jaxrs.xml.elements.Depth;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.LockRoot;
import net.java.dev.webdav.jaxrs.xml.elements.LockScope;
import net.java.dev.webdav.jaxrs.xml.elements.LockToken;
import net.java.dev.webdav.jaxrs.xml.elements.LockType;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Owner;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.elements.TimeOut;
import net.java.dev.webdav.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.jaxrs.xml.properties.DisplayName;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.jaxrs.xml.properties.GetLastModified;
import net.java.dev.webdav.jaxrs.xml.properties.LockDiscovery;
import net.java.dev.webdav.jaxrs.xml.properties.ResourceType;
import net.java.dev.webdav.jaxrs.xml.properties.SupportedLock;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.ecm.webdav.jaxrs.IsCollection;
import org.nuxeo.ecm.webdav.jaxrs.IsFolder;
import org.nuxeo.ecm.webdav.jaxrs.IsHidden;
import org.nuxeo.ecm.webdav.resource.AbstractResource;
import org.nuxeo.ecm.webdav.resource.PropStatBuilderExt;

public class VirtualFolderResource
extends AbstractResource {
    private LinkedList<String> rootFolderNames;

    public VirtualFolderResource(String path, HttpServletRequest request, LinkedList<String> rootFolderNames) {
        super(path, request);
        this.rootFolderNames = rootFolderNames;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><p>");
        sb.append("Folder listing for ");
        sb.append(this.path);
        sb.append("/");
        sb.append("</p>\n<ul>\n");
        for (String name : this.rootFolderNames) {
            String qname = StringEscapeUtils.escapeHtml((String)name);
            sb.append("<li><a href=\"");
            sb.append(qname);
            sb.append("/");
            sb.append("\">");
            sb.append(qname);
            sb.append("</a></li>\n");
        }
        sb.append("</ul></body>\n");
        return sb.toString();
    }

    @PROPFIND
    public Response propfind(@Context UriInfo uriInfo, @HeaderParam(value="depth") String depth) {
        if (depth == null) {
            depth = "1";
        }
        Date lastModified = new Date();
        Date creationDate = new Date();
        net.java.dev.webdav.jaxrs.xml.elements.Response response = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new Object[]{new DisplayName("nuxeo"), new LockDiscovery(), new SupportedLock(), new IsFolder("t"), new IsCollection(1), new IsHidden(0), new GetContentType("application/octet-stream"), new GetContentLength(0L), new CreationDate(creationDate), new GetLastModified(lastModified), ResourceType.COLLECTION}), new Status(Response.Status.OK)), new PropStat[0]);
        if (depth.equals("0")) {
            return Response.status((int)207).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response})).build();
        }
        ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response> responses = new ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response>();
        responses.add(response);
        for (String name : this.rootFolderNames) {
            lastModified = new Date();
            creationDate = new Date();
            PropStatBuilderExt props = new PropStatBuilderExt();
            props.lastModified(lastModified).creationDate(creationDate).displayName(name).status(Response.Status.OK);
            props.isCollection();
            PropStat found = props.build();
            URI childUri = uriInfo.getRequestUriBuilder().path(name).build(new Object[0]);
            net.java.dev.webdav.jaxrs.xml.elements.Response childResponse = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(childUri), null, null, null, found, new PropStat[0]);
            responses.add(childResponse);
        }
        MultiStatus st = new MultiStatus(responses.toArray(new net.java.dev.webdav.jaxrs.xml.elements.Response[responses.size()]));
        return Response.status((int)207).entity((Object)st).build();
    }

    @DELETE
    public Response delete() {
        return Response.status((int)401).build();
    }

    @COPY
    public Response copy() {
        return Response.status((int)401).build();
    }

    @MOVE
    public Response move() {
        return Response.status((int)401).build();
    }

    @PROPPATCH
    public Response proppatch() {
        return Response.status((int)401).build();
    }

    @MKCOL
    public Response mkcol() {
        return Response.status((int)405).build();
    }

    @HEAD
    public Response head() {
        return Response.status((int)404).build();
    }

    @LOCK
    public Response lock(@Context UriInfo uriInfo) {
        Prop prop = new Prop(new Object[]{new LockDiscovery(new ActiveLock[]{new ActiveLock(LockScope.EXCLUSIVE, LockType.WRITE, Depth.ZERO, new Owner(new Object[]{"Administrator"}), new TimeOut(10000L), new LockToken(new HRef("urn:uuid:Administrator")), new LockRoot(new HRef(uriInfo.getRequestUri())))})});
        return Response.ok().entity((Object)prop).header("Lock-Token", (Object)"urn:uuid:Administrator").build();
    }

    @UNLOCK
    public Response unlock() {
        return Response.status((int)204).build();
    }
}

