/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.ecm.user.invite.AlreadyProcessedRegistrationException;
import org.nuxeo.ecm.user.invite.DefaultInvitationUserFactory;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;
import org.nuxeo.ecm.user.invite.RegistrationRules;
import org.nuxeo.ecm.user.invite.RenderingHelper;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserInvitationComponent
extends DefaultComponent
implements UserInvitationService {
    public static final String PARAM_ORIGINATING_USER = "registration:originatingUser";
    protected static Log log = LogFactory.getLog(UserInvitationService.class);
    public static final String NUXEO_URL_KEY = "nuxeo.url";
    protected String repoName = null;
    protected String testRendering = null;
    protected RenderingHelper rh = new RenderingHelper();
    protected Map<String, UserRegistrationConfiguration> configurations = new HashMap<String, UserRegistrationConfiguration>();
    private static final String INVITATION_SUBMITTED_EVENT = "invitationSubmitted";
    private static final String INVITATION_ACCEPTED_EVENT = "invitationAccepted";
    private static final String INVITATION_REJECTED_EVENT = "invitationRejected";
    private static final String INVITATION_VALIDATED_EVENT = "invitationValidated";

    public String getTestedRendering() {
        return this.testRendering;
    }

    protected String getTargetRepositoryName() {
        if (this.repoName == null) {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            this.repoName = rm.getDefaultRepositoryName();
        }
        return this.repoName;
    }

    protected boolean userAlreadyExists(UserRegistrationInfo userRegistrationInfo) {
        DocumentModel user = ((UserManager)Framework.getService(UserManager.class)).getUserModel(userRegistrationInfo.getLogin());
        return user != null;
    }

    protected String getJavaMailJndiName() {
        return Framework.getProperty((String)"jndi.java.mail", (String)"java:/Mail");
    }

    @Override
    public DocumentModel getUserRegistrationModel(String configurationName) {
        if (StringUtils.isEmpty((CharSequence)configurationName)) {
            configurationName = "default_registration";
        }
        UserRegistrationModelCreator creator = new UserRegistrationModelCreator(configurationName);
        creator.runUnrestricted();
        return creator.getUserRegistrationModel();
    }

    @Override
    public DocumentModel getRegistrationRulesDocument(CoreSession session, String configurationName) {
        return this.getOrCreateRootDocument(session, configurationName);
    }

    public DocumentModel getOrCreateRootDocument(CoreSession session, String configurationName) {
        DocumentModel root;
        UserRegistrationConfiguration configuration = this.getConfiguration(configurationName);
        String targetPath = configuration.getContainerParentPath() + configuration.getContainerName();
        PathRef targetRef = new PathRef(targetPath);
        if (!session.exists((DocumentRef)targetRef)) {
            root = session.createDocumentModel(configuration.getContainerDocType());
            root.setPathInfo(configuration.getContainerParentPath(), configuration.getContainerName());
            root.setPropertyValue("dc:title", (Serializable)((Object)configuration.getContainerTitle()));
            root = session.createDocument(root);
        } else {
            root = session.getDocument((DocumentRef)targetRef);
        }
        if (!root.hasFacet("RegistrationConfiguration")) {
            root.addFacet("RegistrationConfiguration");
            root.setPropertyValue("registrationconfiguration:name", (Serializable)((Object)configuration.getName()));
            root = session.saveDocument(root);
        }
        return root;
    }

    protected EventContext sendEvent(CoreSession session, DocumentModel source, String evName) throws UserRegistrationException {
        try {
            EventService evService = (EventService)Framework.getService(EventService.class);
            DocumentEventContext evContext = new DocumentEventContext(session, session.getPrincipal(), source);
            Event event = evContext.newEvent(evName);
            evService.fireEvent(event);
            return evContext;
        }
        catch (UserRegistrationException ue) {
            log.warn((Object)"Error during event processing", (Throwable)((Object)ue));
            throw ue;
        }
    }

    protected void sendValidationEmail(Map<String, Serializable> additionnalInfo, DocumentModel registrationDoc) {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        this.sendEmail(additionnalInfo, registrationDoc, configuration.getValidationEmailTemplate(), configuration.getValidationEmailTitle());
    }

    protected void sendEmail(Map<String, Serializable> additionnalInfo, DocumentModel registrationDoc, String emailTemplatePath, String emailTitle) {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        String emailAdress = (String)((Object)registrationDoc.getPropertyValue(configuration.getUserInfoEmailField()));
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        HashMap<String, Object> userinfo = new HashMap<String, Object>();
        userinfo.put("firstName", registrationDoc.getPropertyValue(configuration.getUserInfoFirstnameField()));
        userinfo.put("lastName", registrationDoc.getPropertyValue(configuration.getUserInfoLastnameField()));
        userinfo.put("login", registrationDoc.getPropertyValue(configuration.getUserInfoUsernameField()));
        userinfo.put("id", registrationDoc.getId());
        String documentTitle = "";
        if (registrationDoc.hasSchema("docinfo")) {
            documentTitle = (String)((Object)registrationDoc.getPropertyValue("docinfo:documentTitle"));
        }
        input.put("documentTitle", (Serializable)((Object)documentTitle));
        input.put("configurationName", (Serializable)((Object)configuration.getName()));
        input.put("comment", registrationDoc.getPropertyValue("registration:comment"));
        input.put("configurationName", (Serializable)((Object)configuration.getName()));
        input.put("userinfo", userinfo);
        input.put("info", (Serializable)((Object)additionnalInfo));
        input.put("userAlreadyExists", Boolean.valueOf(this.checkUserFromRegistrationExistence(registrationDoc)));
        input.put("productName", (Serializable)((Object)Framework.getProperty((String)"org.nuxeo.ecm.product.name")));
        StringWriter writer = new StringWriter();
        try {
            this.rh.getRenderingEngine().render(emailTemplatePath, input, (Writer)writer);
        }
        catch (RenderingException e) {
            throw new NuxeoException("Error during rendering email", (Throwable)e);
        }
        emailTitle = this.renderSubjectTemplate(emailTitle, input);
        String body = writer.getBuffer().toString();
        String copyTo = (String)((Object)registrationDoc.getPropertyValue("registration:copyTo"));
        if (!UserInvitationComponent.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, copyTo, emailTitle, body);
            }
            catch (MessagingException | NamingException e) {
                throw new NuxeoException("Error while sending mail: ", e);
            }
        } else {
            this.testRendering = body;
        }
    }

    private String renderSubjectTemplate(String emailTitle, Map<String, Serializable> input) {
        StringWriter out;
        Configuration stringCfg = this.rh.getEngineConfiguration();
        try {
            Template templ = new Template("subjectTemplate", (Reader)new StringReader(emailTitle), stringCfg);
            out = new StringWriter();
            templ.process(input, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException | IOException e) {
            throw new NuxeoException("Error while rendering email subject: ", e);
        }
        return ((Object)out).toString();
    }

    protected static boolean isTestModeSet() {
        return Framework.isTestModeSet() || !StringUtils.isBlank((CharSequence)Framework.getProperty((String)"org.nuxeo.ecm.tester.name"));
    }

    protected boolean checkUserFromRegistrationExistence(DocumentModel registrationDoc) {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        return null != ((UserManager)Framework.getService(UserManager.class)).getPrincipal((String)((Object)registrationDoc.getPropertyValue(configuration.getUserInfoUsernameField())));
    }

    protected void generateMail(String destination, String copy, String title, String content) throws NamingException, MessagingException {
        InitialContext ic = new InitialContext();
        Session session = (Session)ic.lookup(this.getJavaMailJndiName());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(session.getProperty("mail.from")));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)destination, (boolean)false));
        if (!StringUtils.isBlank((CharSequence)copy)) {
            msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(copy, false));
        }
        msg.setSubject(title, "UTF-8");
        msg.setSentDate(new Date());
        msg.setContent((Object)content, "text/html; charset=utf-8");
        Transport.send((Message)msg);
    }

    @Override
    public String submitRegistrationRequest(DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) {
        return this.submitRegistrationRequest("default_registration", userRegistrationModel, additionnalInfo, validationMethod, autoAccept);
    }

    @Override
    public DocumentModelList getRegistrationsForUser(final String docId, final String username, final String configurationName) {
        DocumentModelListImpl registrationDocs = new DocumentModelListImpl();
        new UnrestrictedSessionRunner(this.getTargetRepositoryName(), (DocumentModelList)registrationDocs){
            final /* synthetic */ DocumentModelList val$registrationDocs;
            {
                this.val$registrationDocs = documentModelList;
                super(x0);
            }

            public void run() {
                String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'validated' AND ecm:mixinType = '" + UserInvitationComponent.this.getConfiguration(configurationName).getRequestDocType() + "' AND docinfo:documentId = '%s' AND" + UserInvitationComponent.this.getConfiguration(configurationName).getUserInfoUsernameField() + " = '%s' AND ecm:isVersion = 0";
                query = String.format(query, docId, username);
                this.val$registrationDocs.addAll((Collection)this.session.query(query));
            }
        }.runUnrestricted();
        return registrationDocs;
    }

    protected static boolean isEmailExist(UserRegistrationConfiguration configuration, DocumentModel userRegistration) {
        String email = (String)((Object)userRegistration.getPropertyValue(configuration.getUserInfoEmailField()));
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        HashMap<String, String> filter = new HashMap<String, String>(1);
        filter.put("email", email);
        DocumentModelList users = ((UserManager)Framework.getService(UserManager.class)).searchUsers(filter, null);
        return !users.isEmpty();
    }

    @Override
    public String submitRegistrationRequest(String configurationName, DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) {
        boolean userAlreadyExists;
        if (StringUtils.isBlank((CharSequence)((String)((Object)additionnalInfo.get(PARAM_ORIGINATING_USER))))) {
            throw new IllegalArgumentException("Originating user should be provided in a registration request");
        }
        RegistrationCreator creator = new RegistrationCreator(configurationName, userRegistrationModel, additionnalInfo, validationMethod);
        creator.runUnrestricted();
        String registrationUuid = creator.getRegistrationUuid();
        UserRegistrationConfiguration currentConfig = this.getConfiguration(configurationName);
        boolean bl = userAlreadyExists = null != ((UserManager)Framework.getService(UserManager.class)).getPrincipal((String)((Object)userRegistrationModel.getPropertyValue(currentConfig.getUserInfoUsernameField())));
        if (!userAlreadyExists && UserInvitationComponent.isEmailExist(currentConfig, userRegistrationModel)) {
            log.info((Object)"Trying to submit a registration from an existing email with a different username.");
            throw new UserAlreadyExistsException();
        }
        RegistrationRules registrationRules = this.getRegistrationRules(configurationName);
        boolean byPassAdminValidation = autoAccept;
        byPassAdminValidation |= userAlreadyExists && registrationRules.allowDirectValidationForExistingUser();
        if (byPassAdminValidation |= !userAlreadyExists && registrationRules.allowDirectValidationForNonExistingUser()) {
            if (!additionnalInfo.containsKey("enterPasswordUrl")) {
                additionnalInfo.put("enterPasswordUrl", (Serializable)((Object)this.buildEnterPasswordUrl(currentConfig)));
            }
            this.acceptRegistrationRequest(registrationUuid, additionnalInfo);
        }
        return registrationUuid;
    }

    protected String buildEnterPasswordUrl(UserRegistrationConfiguration configuration) {
        String baseUrl = Framework.getProperty((String)NUXEO_URL_KEY);
        String string = baseUrl = StringUtils.isBlank((CharSequence)baseUrl) ? "/" : baseUrl;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl.concat(configuration.getEnterPasswordUrl());
    }

    @Override
    public void acceptRegistrationRequest(String requestId, Map<String, Serializable> additionnalInfo) throws UserRegistrationException {
        RegistrationApprover acceptor = new RegistrationApprover(requestId, additionnalInfo);
        acceptor.runUnrestricted();
    }

    @Override
    public void rejectRegistrationRequest(String requestId, Map<String, Serializable> additionnalInfo) throws UserRegistrationException {
        RegistrationRejector rejector = new RegistrationRejector(requestId, additionnalInfo);
        rejector.runUnrestricted();
    }

    @Override
    public Map<String, Serializable> validateRegistration(String requestId, Map<String, Serializable> additionnalInfo) throws UserRegistrationException {
        RegistrationAcceptator validator = new RegistrationAcceptator(requestId, additionnalInfo);
        validator.runUnrestricted();
        return validator.getRegistrationData();
    }

    @Override
    public Map<String, Serializable> validateRegistrationAndSendEmail(String requestId, Map<String, Serializable> additionnalInfo) throws UserRegistrationException {
        Map<String, Serializable> registrationInfo = this.validateRegistration(requestId, additionnalInfo);
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        input.putAll(registrationInfo);
        input.put("info", (Serializable)((Object)additionnalInfo));
        StringWriter writer = new StringWriter();
        UserRegistrationConfiguration configuration = this.getConfiguration((DocumentModel)registrationInfo.get("registrationDoc"));
        try {
            this.rh.getRenderingEngine().render(configuration.getSuccessEmailTemplate(), input, (Writer)writer);
        }
        catch (RenderingException e) {
            throw new NuxeoException("Error during rendering email", (Throwable)e);
        }
        String emailAdress = ((NuxeoPrincipalImpl)registrationInfo.get("registeredUser")).getEmail();
        String body = writer.getBuffer().toString();
        String title = configuration.getValidationEmailTitle();
        if (!Framework.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, null, title, body);
            }
            catch (MessagingException | NamingException e) {
                throw new NuxeoException("Error while sending mail : ", e);
            }
        } else {
            this.testRendering = body;
        }
        return registrationInfo;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("configuration".equals(extensionPoint)) {
            UserRegistrationConfiguration newConfig = (UserRegistrationConfiguration)contribution;
            if (this.configurations.containsKey(newConfig.getName())) {
                if (newConfig.isMerge()) {
                    this.configurations.get(newConfig.getName()).mergeWith(newConfig);
                } else if (newConfig.isRemove()) {
                    this.configurations.remove(newConfig.getName());
                } else {
                    log.warn((Object)("Trying to register an existing userRegistration configuration without removing or merging it, in: " + contributor.getName()));
                }
            } else {
                this.configurations.put(newConfig.getName(), newConfig);
            }
        }
    }

    protected InvitationUserFactory getRegistrationUserFactory(UserRegistrationConfiguration configuration) {
        InvitationUserFactory factory = null;
        Class<? extends InvitationUserFactory> factoryClass = configuration.getRegistrationUserFactory();
        if (factoryClass != null) {
            try {
                factory = factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.warn((Object)"Failed to instanciate RegistrationUserFactory", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultInvitationUserFactory();
        }
        return factory;
    }

    @Override
    public NuxeoPrincipal createUser(CoreSession session, DocumentModel registrationDoc) throws UserRegistrationException {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        return this.getRegistrationUserFactory(configuration).doCreateUser(session, registrationDoc, configuration);
    }

    @Override
    public UserRegistrationConfiguration getConfiguration() {
        return this.getConfiguration("default_registration");
    }

    @Override
    public UserRegistrationConfiguration getConfiguration(DocumentModel requestDoc) {
        try {
            DocumentModel parent = requestDoc.getCoreSession().getDocument(requestDoc.getParentRef());
            String configurationName = "default_registration";
            if (parent.hasFacet("RegistrationConfiguration")) {
                configurationName = (String)((Object)parent.getPropertyValue("registrationconfiguration:name"));
            } else if (requestDoc.hasFacet("RegistrationConfiguration")) {
                configurationName = (String)((Object)requestDoc.getPropertyValue("registrationconfiguration:name"));
            }
            if (!this.configurations.containsKey(configurationName)) {
                throw new NuxeoException("Configuration " + configurationName + " is not registered");
            }
            return this.configurations.get(configurationName);
        }
        catch (NuxeoException e) {
            log.info((Object)("Unable to get request parent document: " + e.getMessage()));
            throw e;
        }
    }

    @Override
    public UserRegistrationConfiguration getConfiguration(String name) {
        if (!this.configurations.containsKey(name)) {
            throw new NuxeoException("Trying to get unknown user registration configuration.");
        }
        return this.configurations.get(name);
    }

    @Override
    public RegistrationRules getRegistrationRules(String configurationName) {
        RootDocumentGetter rdg = new RootDocumentGetter(configurationName);
        rdg.runUnrestricted();
        return (RegistrationRules)rdg.getDoc().getAdapter(RegistrationRules.class);
    }

    @Override
    public void reviveRegistrationRequests(CoreSession session, List<DocumentModel> registrationDocs) {
        for (DocumentModel registrationDoc : registrationDocs) {
            this.reviveRegistrationRequest(session, registrationDoc, new HashMap<String, Serializable>());
        }
    }

    protected void reviveRegistrationRequest(CoreSession session, DocumentModel registrationDoc, Map<String, Serializable> additionalInfos) {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        if (!additionalInfos.containsKey("enterPasswordUrl")) {
            additionalInfos.put("enterPasswordUrl", (Serializable)((Object)this.buildEnterPasswordUrl(configuration)));
        }
        this.sendEmail(additionalInfos, registrationDoc, configuration.getReviveEmailTemplate(), configuration.getReviveEmailTitle());
    }

    @Override
    public void deleteRegistrationRequests(CoreSession session, List<DocumentModel> registrationDocs) {
        for (DocumentModel registration : registrationDocs) {
            UserRegistrationConfiguration configuration;
            if (!registration.hasSchema((configuration = this.getConfiguration(registration)).getUserInfoSchemaName())) {
                throw new NuxeoException("Registration document do not contains needed schema");
            }
            session.removeDocument(registration.getRef());
        }
    }

    @Override
    public Set<String> getConfigurationsName() {
        return this.configurations.keySet();
    }

    @Override
    public void checkRequestId(String requestId) throws UserRegistrationException {
        RequestIdValidator runner = new RequestIdValidator(requestId);
        runner.runUnrestricted();
    }

    @Override
    public String getNameEventRegistrationSubmitted() {
        return INVITATION_SUBMITTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationAccepted() {
        return INVITATION_ACCEPTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationRejected() {
        return INVITATION_REJECTED_EVENT;
    }

    @Override
    public String getNameEventRegistrationValidated() {
        return INVITATION_VALIDATED_EVENT;
    }

    protected class RootDocumentGetter
    extends UnrestrictedSessionRunner {
        protected DocumentModel doc;
        protected String configurationName;

        protected RootDocumentGetter(String configurationName) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.configurationName = configurationName;
        }

        public void run() {
            this.doc = UserInvitationComponent.this.getOrCreateRootDocument(this.session, this.configurationName);
            this.doc.detach(true);
        }

        public DocumentModel getDoc() {
            return this.doc;
        }
    }

    protected class RequestIdValidator
    extends UnrestrictedSessionRunner {
        protected String uuid;

        public RequestIdValidator(String uuid) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = uuid;
        }

        public void run() {
            IdRef idRef = new IdRef(this.uuid);
            if (!this.session.exists((DocumentRef)idRef)) {
                throw new UserRegistrationException("There is no existing registration request with id " + this.uuid);
            }
            DocumentModel registrationDoc = this.session.getDocument((DocumentRef)idRef);
            if (registrationDoc.getCurrentLifeCycleState().equals("accepted")) {
                throw new AlreadyProcessedRegistrationException("Registration request has already been processed");
            }
        }
    }

    protected class RegistrationAcceptator
    extends UnrestrictedSessionRunner {
        protected String uuid;
        protected Map<String, Serializable> registrationData;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationAcceptator(String uuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.registrationData = new HashMap<String, Serializable>();
            this.uuid = uuid;
            this.additionnalInfo = additionnalInfo;
        }

        public Map<String, Serializable> getRegistrationData() {
            return this.registrationData;
        }

        public void run() {
            IdRef idRef = new IdRef(this.uuid);
            DocumentModel registrationDoc = this.session.getDocument((DocumentRef)idRef);
            for (String key : this.additionnalInfo.keySet()) {
                try {
                    if ("invitationPassword".equals(key)) {
                        registrationDoc.putContextData("invitationPassword", this.additionnalInfo.get(key));
                        continue;
                    }
                    registrationDoc.setPropertyValue(key, this.additionnalInfo.get(key));
                }
                catch (PropertyException propertyException) {}
            }
            NuxeoPrincipal principal = null;
            if (registrationDoc.getLifeCyclePolicy().equals("registrationRequest")) {
                if (registrationDoc.getCurrentLifeCycleState().equals("approved")) {
                    try {
                        UserInvitationService userRegistrationService = (UserInvitationService)Framework.getService(UserInvitationService.class);
                        UserRegistrationConfiguration config = userRegistrationService.getConfiguration(registrationDoc);
                        RegistrationRules rules = userRegistrationService.getRegistrationRules(config.getName());
                        if (rules.allowUserCreation()) {
                            principal = userRegistrationService.createUser(this.session, registrationDoc);
                        }
                        registrationDoc.followTransition("accept");
                    }
                    catch (NuxeoException e) {
                        e.addInfo("Unable to complete registration");
                        throw e;
                    }
                } else {
                    if (registrationDoc.getCurrentLifeCycleState().equals("accepted")) {
                        throw new AlreadyProcessedRegistrationException("Registration request has already been processed");
                    }
                    throw new UserRegistrationException("Registration request has not been accepted yet");
                }
            }
            this.session.saveDocument(registrationDoc);
            this.session.save();
            UserInvitationComponent.this.sendEvent(this.session, registrationDoc, UserInvitationComponent.this.getNameEventRegistrationValidated());
            registrationDoc.detach(this.sessionIsAlreadyUnrestricted);
            this.registrationData.put("registrationDoc", (Serializable)registrationDoc);
            this.registrationData.put("registeredUser", (Serializable)principal);
        }
    }

    protected class RegistrationRejector
    extends UnrestrictedSessionRunner {
        protected String uuid;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationRejector(String registrationUuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = registrationUuid;
            this.additionnalInfo = additionnalInfo;
        }

        public void run() {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.uuid));
            doc.setPropertyValue("registration:accepted", (Serializable)Boolean.valueOf(false));
            if (doc.getAllowedStateTransitions().contains("reject")) {
                doc.followTransition("reject");
            }
            doc = this.session.saveDocument(doc);
            this.session.save();
            UserInvitationComponent.this.sendEvent(this.session, doc, UserInvitationComponent.this.getNameEventRegistrationRejected());
        }
    }

    protected class RegistrationApprover
    extends UnrestrictedSessionRunner {
        private final UserManager userManager;
        protected String uuid;
        protected Map<String, Serializable> additionnalInfo;

        public RegistrationApprover(String registrationUuid, Map<String, Serializable> additionnalInfo) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.uuid = registrationUuid;
            this.additionnalInfo = additionnalInfo;
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }

        public void run() {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.uuid));
            String validationMethod = (String)((Object)doc.getPropertyValue("registration:validationMethod"));
            NuxeoPrincipal targetPrincipal = this.userManager.getPrincipal((String)((Object)doc.getPropertyValue("userinfo:login")));
            if (targetPrincipal != null) {
                throw new UserAlreadyExistsException();
            }
            targetPrincipal = this.userManager.getPrincipal((String)((Object)doc.getPropertyValue("userinfo:email")));
            if (targetPrincipal != null) {
                DocumentModel target = this.session.getDocument((DocumentRef)new IdRef((String)((Object)doc.getPropertyValue("docinfo:documentId"))));
                ACP acp = target.getACP();
                HashMap<String, Serializable> contextData = new HashMap<String, Serializable>();
                contextData.put("notify", Boolean.valueOf(true));
                contextData.put("comment", doc.getPropertyValue("registration:comment"));
                acp.addACE("local", ACE.builder((String)targetPrincipal.getName(), (String)((String)((Object)doc.getPropertyValue("docinfo:permission")))).creator((String)((Object)doc.getPropertyValue("docinfo:creator"))).contextData(contextData).build());
                target.setACP(acp, true);
            } else if (StringUtils.equals((CharSequence)UserInvitationService.ValidationMethod.EMAIL.toString(), (CharSequence)validationMethod)) {
                UserInvitationComponent.this.sendValidationEmail(this.additionnalInfo, doc);
            }
            doc.setPropertyValue("registration:accepted", (Serializable)Boolean.valueOf(true));
            if (doc.getAllowedStateTransitions().contains("approve")) {
                doc.followTransition("approve");
            }
            doc = this.session.saveDocument(doc);
            this.session.save();
            UserInvitationComponent.this.sendEvent(this.session, doc, UserInvitationComponent.this.getNameEventRegistrationAccepted());
        }
    }

    protected class RegistrationCreator
    extends UnrestrictedSessionRunner {
        protected Map<String, Serializable> additionnalInfo;
        protected String registrationUuid;
        protected UserInvitationService.ValidationMethod validationMethod;
        protected DocumentModel userRegistrationModel;
        protected UserRegistrationConfiguration configuration;

        public String getRegistrationUuid() {
            return this.registrationUuid;
        }

        public RegistrationCreator(String configurationName, DocumentModel userRegistrationModel, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.userRegistrationModel = userRegistrationModel;
            this.additionnalInfo = additionnalInfo;
            this.validationMethod = validationMethod;
            this.configuration = UserInvitationComponent.this.getConfiguration(configurationName);
        }

        public void run() {
            String title = "registration request for " + this.userRegistrationModel.getPropertyValue(this.configuration.getUserInfoUsernameField()) + " (" + this.userRegistrationModel.getPropertyValue(this.configuration.getUserInfoEmailField()) + " " + this.userRegistrationModel.getPropertyValue(this.configuration.getUserInfoCompanyField()) + ") ";
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            String name = pss.generatePathSegment(title + "-" + System.currentTimeMillis());
            String targetPath = UserInvitationComponent.this.getOrCreateRootDocument(this.session, this.configuration.getName()).getPathAsString();
            this.userRegistrationModel.setPathInfo(targetPath, name);
            this.userRegistrationModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            this.userRegistrationModel.setPropertyValue("registration:validationMethod", (Serializable)((Object)this.validationMethod.toString()));
            if (this.additionnalInfo != null && !this.additionnalInfo.isEmpty()) {
                for (String key : this.additionnalInfo.keySet()) {
                    try {
                        this.userRegistrationModel.setPropertyValue(key, this.additionnalInfo.get(key));
                    }
                    catch (PropertyException propertyException) {}
                }
            }
            this.userRegistrationModel = this.session.createDocument(this.userRegistrationModel);
            this.registrationUuid = this.userRegistrationModel.getId();
            UserInvitationComponent.this.sendEvent(this.session, this.userRegistrationModel, UserInvitationComponent.this.getNameEventRegistrationSubmitted());
            this.session.save();
        }
    }

    protected class UserRegistrationModelCreator
    extends UnrestrictedSessionRunner {
        DocumentModel userRegistrationModel;
        protected UserRegistrationConfiguration configuration;

        public UserRegistrationModelCreator(String configurationName) {
            super(UserInvitationComponent.this.getTargetRepositoryName());
            this.configuration = UserInvitationComponent.this.getConfiguration(configurationName);
        }

        public void run() {
            this.userRegistrationModel = this.session.createDocumentModel(this.configuration.getRequestDocType());
        }

        public DocumentModel getUserRegistrationModel() {
            return this.userRegistrationModel;
        }
    }
}

