/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.restlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.diff.content.ContentDiffAdapter;
import org.nuxeo.ecm.diff.content.adapter.base.ContentDiffConversionType;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;

public class ContentDiffRestlet
extends BaseNuxeoRestlet {
    private static final Log log = LogFactory.getLog(ContentDiffRestlet.class);
    protected Locale locale;
    protected DocumentModel leftDoc;
    protected DocumentModel rightDoc;

    public void handle(Request req, Response res) {
        int pos;
        this.logDeprecation();
        HttpServletResponse response = ContentDiffRestlet.getHttpResponse((Response)res);
        HttpServletRequest request = ContentDiffRestlet.getHttpRequest((Request)req);
        String repo = (String)req.getAttributes().get("repo");
        String leftDocId = (String)req.getAttributes().get("leftDocId");
        String rightDocId = (String)req.getAttributes().get("rightDocId");
        String xpath = (String)req.getAttributes().get("fieldXPath");
        xpath = xpath.replace("--", "/");
        List segments = req.getResourceRef().getSegments();
        StringBuilder sb = new StringBuilder();
        for (int i = pos = segments.indexOf("restAPI") + 6; i < segments.size(); ++i) {
            sb.append((String)segments.get(i));
            sb.append("/");
        }
        String subPath = sb.substring(0, sb.length() - 1);
        String conversionTypeParam = ContentDiffRestlet.getQueryParamValue((Request)req, (String)"conversionType", (String)ContentDiffConversionType.html.name());
        ContentDiffConversionType conversionType = ContentDiffConversionType.valueOf(conversionTypeParam);
        String localeParam = ContentDiffRestlet.getQueryParamValue((Request)req, (String)"locale", null);
        this.locale = StringUtils.isBlank((CharSequence)localeParam) ? Locale.getDefault() : LocaleUtils.toLocale((String)localeParam);
        try {
            xpath = URLDecoder.decode(xpath, "UTF-8");
            subPath = URLDecoder.decode(subPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        if (repo == null || repo.equals("*")) {
            ContentDiffRestlet.handleError((Response)res, (String)"You must specify a repository.");
            return;
        }
        if (leftDocId == null || leftDocId.equals("*")) {
            ContentDiffRestlet.handleError((Response)res, (String)"You must specify a left document id.");
            return;
        }
        if (rightDocId == null || rightDocId.equals("*")) {
            ContentDiffRestlet.handleError((Response)res, (String)"You must specify a right document id.");
            return;
        }
        try (CloseableCoreSession documentManager = CoreInstance.openCoreSession((String)repo);){
            this.leftDoc = documentManager.getDocument((DocumentRef)new IdRef(leftDocId));
            this.rightDoc = documentManager.getDocument((DocumentRef)new IdRef(rightDocId));
            List<Blob> contentDiffBlobs = this.initCachedContentDiffBlobs(res, xpath, conversionType);
            if (CollectionUtils.isEmpty(contentDiffBlobs)) {
                return;
            }
            Blob blob = null;
            if (StringUtils.isEmpty((CharSequence)subPath)) {
                blob = contentDiffBlobs.get(0);
                blob.setMimeType("text/html");
            } else {
                for (Blob b : contentDiffBlobs) {
                    if (!subPath.equals(b.getFilename())) continue;
                    blob = b;
                    break;
                }
            }
            if (blob == null) {
                res.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return;
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            String reason = "contentDiff";
            Blob fblob = blob;
            Boolean inline = Boolean.TRUE;
            HashMap<String, String> extendedInfos = new HashMap<String, String>();
            extendedInfos.put("subPath", subPath);
            extendedInfos.put("leftDocId", leftDocId);
            extendedInfos.put("rightDocId", rightDocId);
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            if (!downloadService.checkPermission(this.rightDoc, xpath, blob, reason, extendedInfos)) {
                res.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return;
            }
            downloadService.downloadBlob(request, response, this.leftDoc, xpath, blob, blob.getFilename(), reason, extendedInfos, inline, byteRange -> this.setEntityToBlobOutput(fblob, (DownloadService.ByteRange)byteRange, res));
        }
        catch (IOException | NuxeoException e) {
            ContentDiffRestlet.handleError((Response)res, (Exception)e);
        }
    }

    private List<Blob> initCachedContentDiffBlobs(Response res, String xpath, ContentDiffConversionType conversionType) {
        List<Blob> contentDiffBlobs;
        ContentDiffAdapter contentDiffAdapter = (ContentDiffAdapter)this.leftDoc.getAdapter(ContentDiffAdapter.class);
        if (contentDiffAdapter == null) {
            this.handleNoContentDiff(res, xpath, null);
            return null;
        }
        try {
            contentDiffBlobs = xpath.equals("default") ? contentDiffAdapter.getFileContentDiffBlobs(this.rightDoc, conversionType, this.locale) : contentDiffAdapter.getFileContentDiffBlobs(this.rightDoc, xpath, conversionType, this.locale);
        }
        catch (NuxeoException ce) {
            this.handleNoContentDiff(res, xpath, ce);
            return null;
        }
        if (CollectionUtils.isEmpty(contentDiffBlobs)) {
            this.handleNoContentDiff(res, xpath, null);
            return null;
        }
        return contentDiffBlobs;
    }

    protected void handleNoContentDiff(Response res, String xpath, NuxeoException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><center><h1>");
        if (e == null) {
            sb.append("No content diff is available for these documents</h1>");
        } else {
            sb.append("Content diff can not be generated for these documents</h1>");
            sb.append("<pre>Blob path: ");
            sb.append(xpath);
            sb.append("</pre>");
            sb.append("<pre>");
            if (e instanceof ConverterNotRegistered) {
                sb.append(e.getMessage());
            } else {
                sb.append(e.toString());
            }
            sb.append("</pre>");
        }
        sb.append("</center></body></html>");
        log.error((Object)("Could not build content diff for missing blob at " + xpath), (Throwable)e);
        res.setEntity(sb.toString(), MediaType.TEXT_HTML);
        HttpServletResponse response = ContentDiffRestlet.getHttpResponse((Response)res);
        response.setHeader("Content-Disposition", "inline");
    }
}

